/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.burlap.BurlapProtocolException;
import com.caucho.ejb.burlap.BurlapReader;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BurlapSkeleton
extends Skeleton {
    protected static Logger log = Log.open(BurlapSkeleton._resin_compat_class_0());
    private AbstractServer _server;
    private HessianRemoteResolver _resolver;
    private static Class _resin_compat_class_0;

    void _setServer(AbstractServer server) {
        this._server = server;
    }

    void _setResolver(HessianRemoteResolver resolver) {
        this._resolver = resolver;
    }

    protected abstract void _setObject(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _service(InputStream is, OutputStream os) throws Exception {
        BurlapReader in = new BurlapReader(is);
        BurlapWriter out = new BurlapWriter(os);
        in.setRemoteResolver(this._resolver);
        in.startCall();
        String method = in.getMethod();
        CharBuffer cb = new CharBuffer();
        cb.append(method);
        String oldProtocol = EjbProtocolManager.setThreadProtocol("burlap");
        try {
            this._execute(cb, in, out);
        }
        catch (BurlapProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
        finally {
            EjbProtocolManager.setThreadProtocol(oldProtocol);
        }
    }

    protected abstract void _execute(CharBuffer var1, BurlapInput var2, BurlapOutput var3) throws Throwable;

    protected void _executeUnknown(CharBuffer method, BurlapInput in, BurlapOutput out) throws Exception {
        if (method.matches("_burlap_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(this._server.getRemoteObjectClass().getName());
            } else if ("home-class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(this._server.getRemoteObjectClass().getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", new CharBuffer().append("no such method: ").append((Object)method).toString(), null);
            out.completeReply();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.burlap.BurlapSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

