/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.config.ConfigException;
import com.caucho.ejb.burlap.BurlapClientContainer;
import com.caucho.ejb.burlap.BurlapModel;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.ContextImpl;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BurlapContextFactory
implements InitialContextFactory {
    private static final L10N L = new L10N(BurlapContextFactory._resin_compat_class_0());
    private AbstractModel _model;
    private static Class _resin_compat_class_0;

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        String prefix = (String)environment.get("java.naming.provider.url");
        String user = (String)environment.get("java.naming.security.principal");
        String pw = (String)environment.get("java.naming.security.credentials");
        if (user != null) {
            BurlapClientContainer client;
            String auth = Base64.encode(new CharBuffer().append(user).append(':').append(pw).toString());
            if (!prefix.endsWith("/")) {
                prefix = new CharBuffer().append(prefix).append('/').toString();
            }
            BurlapModel model = new BurlapModel(prefix);
            try {
                client = new BurlapClientContainer(model.getURLPrefix());
                client.setBasicAuthentication(auth);
            }
            catch (ConfigException e) {
                throw new NamingException(e.toString());
            }
            model.setClientContainer(client);
            return new ContextImpl(model, environment);
        }
        if (this._model == null) {
            this._model = new BurlapModel(prefix);
        }
        return new ContextImpl(this._model, environment);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.burlap.BurlapContextFactory");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

