/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.amber;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.field.StubMethod;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmpProperty;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.make.PersistentDependency;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberConfig {
    private static final L10N L = new L10N(AmberConfig._resin_compat_class_0());
    private EjbConfig _ejbConfig;
    private AmberManager _manager;
    private ArrayList<EjbEntityBean> _beans = new ArrayList();
    private HashMap<String, EntityType> _entityMap = new HashMap();
    private static Class _resin_compat_class_0;

    public AmberConfig(EjbConfig ejbConfig) {
        this._ejbConfig = ejbConfig;
        this._manager = this._ejbConfig.getEJBManager().getAmberManager();
    }

    public void init() throws ConfigException, IOException {
    }

    public AmberManager getManager() {
        return this._manager;
    }

    public void addBean(EjbEntityBean bean) throws ConfigException {
        String sqlTable;
        this._beans.add(bean);
        EntityType type = bean.getEntityType();
        type.setInstanceClassName(bean.getFullImplName());
        type.setProxyClass(bean.getLocal());
        if (bean.getAbstractSchemaName() != null) {
            type.setName(bean.getAbstractSchemaName());
            sqlTable = bean.getAbstractSchemaName();
        } else {
            String name = bean.getEJBName();
            int p = name.lastIndexOf(47);
            sqlTable = p > 0 ? name.substring(p + 1) : name;
        }
        if (bean.getSQLTable() != null) {
            sqlTable = bean.getSQLTable();
        }
        Table table = this._manager.createTable(sqlTable);
        table.setConfigLocation(bean.getLocation());
        type.setTable(table);
        type.setReadOnly(bean.isReadOnly());
        table.setReadOnly(bean.isReadOnly());
        type.setCacheTimeout(bean.getCacheTimeout());
        if (AmberConfig.hasMethod(bean.getEJBClassWrapper(), "ejbLoad", new JClass[0])) {
            type.setHasLoadCallback(true);
        }
        this._entityMap.put(bean.getEJBName(), type);
        ArrayList<CmpProperty> ids = new ArrayList<CmpProperty>();
        for (CmpField cmpField : bean.getCmpFields()) {
            if (cmpField.isId()) {
                ids.add(cmpField);
                continue;
            }
            this.configureField(type, cmpField);
        }
        for (CmrRelation cmrRelation : bean.getRelations()) {
            if (!cmrRelation.isId()) continue;
            ids.add(cmrRelation);
        }
        this.configureId(bean, type, ids);
        for (JMethod method : bean.getStubMethods()) {
            type.addStubMethod(new StubMethod(method));
        }
        for (PersistentDependency depend : bean.getDependList()) {
            type.addDependency(depend);
        }
    }

    private void configureField(EntityType type, CmpField cmpField) throws ConfigException {
        JClass dataType;
        String fieldName = cmpField.getName();
        String sqlName = cmpField.getSQLColumn();
        if (sqlName == null) {
            sqlName = fieldName;
        }
        if ((dataType = cmpField.getJavaType()) == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown field", fieldName));
        }
        Type amberType = this._manager.createType(dataType);
        Column column = type.getTable().createColumn(sqlName, amberType);
        column.setConfigLocation(cmpField.getLocation());
        PropertyField field = new PropertyField(type, fieldName);
        field.setColumn(column);
        type.addField(field);
    }

    private void configureId(EjbEntityBean bean, EntityType type, ArrayList<CmpProperty> fields) throws ConfigException {
        Id id;
        ArrayList<IdField> keys = new ArrayList<IdField>();
        for (CmpProperty cmpProperty : fields) {
            IdField idField = cmpProperty.createId(this._manager, type);
            if (fields.size() > 1 || bean.getCompositeKeyClass() != null) {
                idField.setKeyField(true);
            }
            keys.add(idField);
        }
        if (keys.size() == 1 && bean.getCompositeKeyClass() == null) {
            id = new Id(type, keys.get(0));
            type.setId(id);
        } else {
            id = new CompositeId(type, keys);
            id.setKeyClass(bean.getPrimKeyClass());
            type.setId(id);
        }
    }

    public void configureRelations() throws ConfigException {
        for (EjbEntityBean bean : this._beans) {
            this.configureRelations(bean);
        }
        for (EjbEntityBean bean : this._beans) {
            this.linkRelations(bean);
        }
    }

    private void configureRelations(EjbEntityBean bean) throws ConfigException {
        EntityType type = bean.getEntityType();
        for (CmrRelation rel : bean.getRelations()) {
            if (rel.isId()) continue;
            this.configureRelation(type, rel);
        }
    }

    private void linkRelations(EjbEntityBean bean) throws ConfigException {
        EntityType type = this._entityMap.get(bean.getEJBName());
        for (CmrRelation rel : bean.getRelations()) {
            rel.linkAmber();
        }
    }

    private void configureRelation(EntityType type, CmrRelation rel) throws ConfigException {
        String fieldName = rel.getName();
        String targetName = rel.getTargetBean().getEJBName();
        EntityType targetType = this._entityMap.get(targetName);
        if (targetType == null) {
            throw new ConfigException(L.l("'{0}' is an unknown entity type", targetName));
        }
        AmberField field = rel.assembleAmber(type);
        if (field != null) {
            type.addField(field);
        }
    }

    public void generate(JavaClassGenerator javaGen) throws Exception {
        this._manager.generate(javaGen);
    }

    private static boolean hasMethod(JClass cl, String name, JClass[] param) {
        try {
            return cl.getMethod(name, param) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.amber.AmberConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

