/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.amber.AmberManager;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.bytecode.JClassLoader;
import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.admin.EJBAdmin;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.entity.EntityKey;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.entity.QEntityContext;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.SimpleLoader;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvServerManager
implements EnvironmentListener {
    private static final L10N L = new L10N(EnvServerManager._resin_compat_class_0());
    protected static final Logger log = Log.open(EnvServerManager._resin_compat_class_0());
    private EnvironmentClassLoader _classLoader;
    private Path _workPath;
    private int _entityCacheSize = 32768;
    private long _entityCacheTimeout = 5000L;
    private ConfigException _initException;
    private EJBAdmin _ejbAdmin;
    private AmberManager _amberManager;
    private EjbTransactionManager _ejbTransactionManager;
    private EjbProtocolManager _protocolManager;
    private ArrayList<EjbConfig> _ejbConfigList = new ArrayList();
    private Hashtable<String, AbstractServer> _serverMap = new Hashtable();
    protected ProtocolContainer _protocolContainer;
    protected HashMap<String, ProtocolContainer> _protocolMap = new HashMap();
    private LruCache<EntityKey, QEntityContext> _entityCache;
    private EntityKey _entityKey = new EntityKey();
    private final Lifecycle _lifecycle = new Lifecycle(log, "ejb-manager");
    private static Class _resin_compat_class_0;

    EnvServerManager(AmberManager amberManager) {
        try {
            this._amberManager = amberManager;
            this._amberManager.initLoaders();
            this._amberManager.setTableCacheTimeout(this._entityCacheTimeout);
            this._classLoader = (EnvironmentClassLoader)Thread.currentThread().getContextClassLoader();
            this._workPath = WorkDir.getLocalWorkDir(this._classLoader).lookup("ejb");
            this._classLoader.addLoader(new SimpleLoader(this._workPath));
            try {
                this._ejbTransactionManager = new EjbTransactionManager(this);
            }
            catch (Throwable e) {
                log.info("transactions are not available to EJB server");
                log.log(Level.FINE, e.toString(), e);
            }
            this._ejbAdmin = new EJBAdmin(this);
            this._protocolManager = new EjbProtocolManager(this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    public EjbProtocolManager getProtocolManager() {
        return this._protocolManager;
    }

    public EjbTransactionManager getTransactionManager() {
        return this._ejbTransactionManager;
    }

    public void setResinIsolation(int resinIsolation) {
        this._ejbTransactionManager.setResinIsolation(resinIsolation);
    }

    public int getResinIsolation() {
        return this._ejbTransactionManager.getResinIsolation();
    }

    public void setJDBCIsolation(int jdbcIsolation) {
        this._ejbTransactionManager.setJDBCIsolation(jdbcIsolation);
    }

    public int getJDBCIsolation() {
        return this._ejbTransactionManager.getJDBCIsolation();
    }

    public long getTransactionTimeout() {
        return this._ejbTransactionManager.getTransactionTimeout();
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this._ejbTransactionManager.setTransactionTimeout(transactionTimeout);
    }

    public Path getWorkPath() {
        return this._workPath;
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public long getCacheTimeout() {
        return this._entityCacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this._entityCacheTimeout = cacheTimeout;
    }

    public int getCacheSize() {
        return this._entityCacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this._entityCacheSize = cacheSize;
    }

    public EJBAdmin getAdmin() {
        return this._ejbAdmin;
    }

    void addEjbConfig(EjbConfig ejbConfig) {
        this._ejbConfigList.add(ejbConfig);
    }

    public void init() throws Exception {
        this.build();
        Environment.addEnvironmentListener(this);
    }

    public void build() throws ConfigException {
        try {
            this._amberManager.init();
            this._entityCache = new LruCache(this._entityCacheSize);
            this._protocolManager.init();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        for (EjbConfig cfg : this._ejbConfigList) {
            cfg.deploy();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        for (AbstractServer server : this._serverMap.values()) {
            try {
                thread.setContextClassLoader(server.getClassLoader());
                log.fine(new CharBuffer().append(server).append(" starting").toString());
                server.start();
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    public AmberEntityHome getAmberEntityHome(String name) {
        return this._amberManager.getEntityHome(name);
    }

    public AmberManager getAmberManager() {
        return this._amberManager;
    }

    public JClassLoader getJClassLoader() {
        return this.getAmberManager().getJClassLoader();
    }

    public void invalidateCache() {
    }

    public void addServer(AbstractServer server) {
        this._serverMap.put(server.getEJBName(), server);
        try {
            this._protocolManager.addServer(server);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public AbstractServer getServer(String serverId) {
        if (serverId.startsWith("/")) {
            return this._serverMap.get(serverId);
        }
        return this._serverMap.get(new CharBuffer().append("/").append(serverId).toString());
    }

    public AbstractServer getServerByEJBName(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = new CharBuffer().append("/").append(ejbName).toString();
        }
        return this._serverMap.get(ejbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QEntityContext getEntity(EntityServer server, Object key) {
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(server, key);
            return this._entityCache.get(this._entityKey);
        }
    }

    public QEntityContext putEntityIfNew(EntityServer server, Object key, QEntityContext context) {
        return this._entityCache.putIfNew(new EntityKey(server, key), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(EntityServer server, Object key) {
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(server, key);
            this._entityCache.remove(this._entityKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeans(ArrayList<QEntityContext> beans, EntityServer server) {
        LruCache<EntityKey, QEntityContext> lruCache = this._entityCache;
        synchronized (lruCache) {
            Iterator<LruCache.Entry<EntityKey, QEntityContext>> iter = this._entityCache.iterator();
            while (iter.hasNext()) {
                LruCache.Entry<EntityKey, QEntityContext> entry = iter.next();
                beans.add(entry.getValue());
                iter.remove();
            }
        }
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) throws Exception {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        try {
            ArrayList<AbstractServer> servers = new ArrayList<AbstractServer>(this._serverMap.values());
            this._serverMap.clear();
            Collections.sort(servers, new ServerCmp());
            for (AbstractServer server : servers) {
                try {
                    this._protocolManager.removeServer(server);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            for (AbstractServer server : servers) {
                try {
                    server.destroy();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._serverMap = null;
            this._protocolManager.destroy();
            this._protocolManager = null;
            this._ejbTransactionManager.destroy();
            this._ejbTransactionManager = null;
            this._amberManager = null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.EnvServerManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServerCmp
    implements Comparator<AbstractServer> {
        ServerCmp() {
        }

        @Override
        public int compare(AbstractServer a, AbstractServer b) {
            return a.getEJBName().compareTo(b.getEJBName());
        }
    }
}

