/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.ejb.EjbServerManager;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.log.Log;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.Logger;

public class EJBCompiler {
    static L10N L = new L10N(EJBCompiler._resin_compat_class_0());
    protected static Logger log = Log.open(EJBCompiler._resin_compat_class_0());
    private Path _classDir;
    private Path _appDir;
    private ArrayList<String> _ejbPath = new ArrayList();
    private static Class _resin_compat_class_0;

    public EJBCompiler(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-app-dir")) {
                this._appDir = Vfs.lookup(args[i + 1]);
                if (this._classDir == null) {
                    this._classDir = this._appDir.lookup("WEB-INF/work");
                }
                i += 2;
                continue;
            }
            if (!args[i].equals("-class-dir")) break;
            this._classDir = Vfs.lookup(args[i + 1]);
            i += 2;
        }
        if (i == args.length) {
            EJBCompiler.printUsage();
            throw new Exception("bad args");
        }
        while (i < args.length) {
            this._ejbPath.add(args[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        EnvironmentClassLoader loader = new EnvironmentClassLoader(oldLoader);
        if (this._appDir != null) {
            loader.addLoader(new SimpleLoader(this._appDir.lookup("WEB-INF/classes"), null));
        }
        Thread.currentThread().setContextClassLoader(loader);
        try {
            EjbServerManager container = new EjbServerManager();
            container.setValidateDatabaseSchema(false);
            if (this._classDir == null) {
                container.setWorkPath(Vfs.lookup("."));
            } else {
                container.setWorkPath(this._classDir);
            }
            MergePath mergePath = new MergePath();
            mergePath.addClassPath(loader);
            if (this._appDir != null) {
                mergePath.addMergePath(this._appDir.lookup("WEB-INF"));
            }
            if (this._classDir != null) {
                mergePath.addMergePath(this._classDir);
            }
            for (int i = 0; i < this._ejbPath.size(); ++i) {
                container.addEJBPath(mergePath.lookup(this._ejbPath.get(i)));
            }
            container.build();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            EJBCompiler.printUsage();
            System.exit(1);
        }
        try {
            new EJBCompiler(args).compile();
        }
        catch (Throwable e) {
            while (e instanceof ExceptionWrapper && ((ExceptionWrapper)((Object)e)).getRootCause() != null) {
                e = ((ExceptionWrapper)((Object)e)).getRootCause();
            }
            throw e;
        }
    }

    private static void printUsage() {
        System.out.println("usage: com.caucho.ejb.EJBCompiler [flags] foo.ejb");
        System.out.println(" -class-dir: The directory where the classes will be generated.");
        System.out.println(" -app-dir: The source (web-app) directory.");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.EJBCompiler");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

