/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.doclet;

import com.caucho.config.Config;
import com.caucho.doclet.RootDocImpl;
import com.caucho.java.WorkDir;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.sun.tools.javadoc.Main;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocletCompiler {
    private static final L10N L = new L10N(DocletCompiler._resin_compat_class_0());
    private static final Logger log = Log.open(DocletCompiler._resin_compat_class_0());
    private String _userPrefix;
    private boolean _isDead;
    private Process _process;
    private Path _srcDir;
    private long _maxCompileTime = 30000L;
    private String _charEncoding;
    private ArrayList<String> _args;
    private static Class _resin_compat_class_0;

    public RootDocImpl run(Path srcDir, ArrayList<String> paths) throws Exception {
        this._srcDir = srcDir;
        return this.compileInt(paths);
    }

    private Path getSourceDir() {
        return this._srcDir;
    }

    private String getSourceDirName() {
        return this._srcDir.getPath();
    }

    private String getCompiler() {
        return "javadoc";
    }

    private String getClassPath() {
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        return loader.getClassPath();
    }

    protected RootDocImpl compileInt(ArrayList<String> paths) throws IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream(tempStream);
        MemoryStream outStream = new MemoryStream();
        WriteStream out = new WriteStream(outStream);
        InputStream inputStream = null;
        InputStream errorStream = null;
        boolean chdir = CauchoSystem.isUnix();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this._process = null;
        try {
            String doclet = this.getCompiler();
            String path = paths.get(0);
            String parent = Vfs.lookupNative(path).getParent().getNativePath();
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(doclet);
            for (int i = 0; this._args != null && i < this._args.size(); ++i) {
                argList.add(this._args.get(i));
            }
            if (this._charEncoding != null) {
                String encoding = Encoding.getJavaName(this._charEncoding);
                argList.add("-encoding");
                argList.add(encoding);
            }
            Path workDir = WorkDir.getLocalWorkDir();
            Path docletPath = workDir.lookup("_doclet/doclet.xml");
            docletPath.getParent().mkdirs();
            String classPath = this.normalizeClassPath(this.getClassPath(), !chdir);
            argList.add("-classpath");
            argList.add(classPath);
            argList.add("-doclet");
            argList.add("com.caucho.doclet.XmlDoclet");
            argList.add("-path");
            argList.add(docletPath.getNativePath());
            String[] env = new String[]{new CharBuffer().append("CLASSPATH=").append(classPath).toString()};
            for (int i = 0; i < paths.size(); ++i) {
                argList.add(this._srcDir.lookup(paths.get(i)).getNativePath());
            }
            String[] args = argList.toArray(new String[argList.size()]);
            TempStream ts = new TempStream(null);
            WriteStream ws = new WriteStream(ts);
            PrintWriter pw = ws.getPrintWriter();
            Main.execute((String)"resin-javadoc", (PrintWriter)pw, (PrintWriter)pw, (PrintWriter)pw, (String)"com.caucho.doclet.XmlDoclet", (String[])args);
            pw.close();
            ws.close();
            if (log.isLoggable(Level.FINER)) {
                int ch;
                ReadStream rs = ts.openRead();
                CharBuffer cb = new CharBuffer();
                while ((ch = rs.read()) >= 0) {
                    cb.append((char)ch);
                }
                log.finer(cb.toString());
            }
            RootDocImpl rootDoc = new RootDocImpl();
            new Config().configure((Object)rootDoc, docletPath);
            RootDocImpl rootDocImpl = rootDoc;
            return rootDocImpl;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            if (inputStream != null) {
                inputStream.close();
            }
            if (errorStream != null) {
                errorStream.close();
            }
            tempStream.destroy();
        }
    }

    String normalizeClassPath(String classPath, boolean generateRelative) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        CharBuffer cb = CharBuffer.allocate();
        while (head < classPath.length()) {
            tail = classPath.indexOf(sep, head);
            if (tail < 0) {
                tail = classPath.length();
            }
            if (tail > head) {
                String segment = classPath.substring(head, tail);
                if (cb.length() != 0) {
                    cb.append(sep);
                }
                cb.append(this.normalizePath(segment, generateRelative));
            }
            head = tail + 1;
        }
        return cb.close();
    }

    String normalizePath(String segment, boolean generateRelative) {
        if (this._userPrefix == null) {
            Path userPath = Vfs.lookup(CauchoSystem.getUserDir());
            char sep = CauchoSystem.getFileSeparatorChar();
            this._userPrefix = userPath.getNativePath();
            if (this._userPrefix.length() == 0 || this._userPrefix.charAt(this._userPrefix.length() - 1) != sep) {
                this._userPrefix = new CharBuffer().append(this._userPrefix).append(sep).toString();
            }
        }
        Path path = Vfs.lookup(segment);
        String nativePath = path.getNativePath();
        if (!generateRelative) {
            return nativePath;
        }
        if (nativePath.startsWith(this._userPrefix)) {
            nativePath = nativePath.substring(this._userPrefix.length());
        }
        if (nativePath.equals("")) {
            return ".";
        }
        return nativePath;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.doclet.DocletCompiler");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

