/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.SQLException;

public class UniqueIndexColumnConstraint
extends Constraint {
    private static final L10N L = new L10N(UniqueIndexColumnConstraint._resin_compat_class_0());
    private final Column _column;
    private static Class _resin_compat_class_0;

    public UniqueIndexColumnConstraint(Column column) {
        this._column = column;
    }

    public void validate(TableIterator[] sourceRows, QueryContext context, Transaction xa) throws SQLException {
        try {
            TableIterator sourceRow = sourceRows[0];
            byte[] sourceBuffer = sourceRow.getBuffer();
            int sourceOffset = sourceRow.getRowOffset();
            byte[] buffer = context.getBuffer();
            int length = this._column.getLength();
            if (length <= 0) {
                return;
            }
            BTree index = this._column.getIndex();
            long value = index.lookup(buffer, 0, length, context.getTransaction());
            if (value != 0L) {
                Table table = sourceRow.getTable();
                throw new SQLException(L.l("`{0}' in {1}.{2} fails uniqueness constraint.", this._column.getString(sourceBuffer, sourceOffset), table.getName(), this._column.getName()));
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.table.UniqueIndexColumnConstraint");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

