/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.SQLException;

public class UniqueConstraint
extends Constraint {
    private static final L10N L = new L10N(UniqueConstraint._resin_compat_class_0());
    private final Column[] _uniqueSet;
    private static Class _resin_compat_class_0;

    public UniqueConstraint(Column[] uniqueSet) {
        this._uniqueSet = uniqueSet;
    }

    public void validate(TableIterator[] sourceRows, QueryContext queryContext, Transaction xa) throws SQLException {
        TableIterator sourceRow = sourceRows[0];
        Object value = null;
        Table table = sourceRow.getTable();
        TableIterator iter = table.createTableIterator();
        byte[] sourceBuffer = sourceRow.getBuffer();
        int sourceOffset = sourceRow.getRowOffset();
        iter.init(queryContext);
        try {
            while (iter.next()) {
                byte[] iterBuffer = iter.getBuffer();
                iter.prevRow();
                while (iter.nextRow()) {
                    int iterOffset = iter.getRowOffset();
                    if (iterBuffer == sourceBuffer && iterOffset == sourceOffset) continue;
                    boolean isMatch = true;
                    for (int i = 0; i < this._uniqueSet.length; ++i) {
                        Column column = this._uniqueSet[i];
                        int columnOffset = column.getColumnOffset();
                        if (column.isEqual(iterBuffer, iterOffset, sourceBuffer, sourceOffset)) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    throw new SQLException(L.l("`{0}' in {1}.{2} fails uniqueness constraint.", this._uniqueSet[0].getString(iterBuffer, iterOffset), table.getName(), this._uniqueSet[0].getName()));
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.table.UniqueConstraint");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

