/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.Database;
import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.CreateQuery;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.Parser;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Block;
import com.caucho.db.store.Store;
import com.caucho.db.store.Transaction;
import com.caucho.db.store.WriteBlock;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.NumericColumn;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableFactory;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends Store {
    private static final Logger log = Log.open(Table._resin_compat_class_0());
    private static final L10N L = new L10N(Table._resin_compat_class_0());
    private static final int ROOT_DATA_OFFSET = 1024;
    private static final int INDEX_ROOT_OFFSET = 1056;
    private static final int ROOT_DATA_END = 2048;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final long ROW_CLOCK_MIN = 1024L;
    private static final String DB_VERSION = "Resin-DB 3.0.15";
    private static final String MIN_VERSION = "Resin-DB 3.0.15";
    private final Row _row;
    private final int _rowLength;
    private final int _rowsPerBlock;
    private final int _rowEnd;
    private final Constraint[] _constraints;
    private final Column _autoIncrementColumn;
    private long _entries;
    private long _rowClockAddr;
    private long _rowClockTotal;
    private long _rowClockUsed;
    private long _autoIncrementValue = -1L;
    private static Class _resin_compat_class_0;

    Table(Database database, String name, Row row, Constraint[] constraints) {
        super(database, name, null);
        this._row = row;
        this._constraints = constraints;
        this._rowLength = this._row.getLength();
        this._rowsPerBlock = 65536 / this._rowLength;
        this._rowEnd = this._rowLength * this._rowsPerBlock;
        this._rowClockAddr = 0L;
        Column[] columns = this._row.getColumns();
        Column autoIncrementColumn = null;
        for (int i = 0; i < columns.length; ++i) {
            columns[i].setTable(this);
            if (columns[i].getAutoIncrement() < 0) continue;
            autoIncrementColumn = columns[i];
        }
        this._autoIncrementColumn = autoIncrementColumn;
    }

    Row getRow() {
        return this._row;
    }

    int getRowLength() {
        return this._rowLength;
    }

    int getRowEnd() {
        return this._rowEnd;
    }

    public final Column[] getColumns() {
        return this._row.getColumns();
    }

    public final Constraint[] getConstraints() {
        return this._constraints;
    }

    public Column getAutoIncrementColumn() {
        return this._autoIncrementColumn;
    }

    public Column getColumn(String name) {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return columns[i];
        }
        return null;
    }

    public int getColumnIndex(String name) throws SQLException {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table loadFromFile(Database db, String name) throws IOException, SQLException {
        int ch;
        Path path = db.getPath().lookup(new CharBuffer().append(name).append(".db").toString());
        if (!path.exists()) {
            throw new IOException(L.l("table {0} does not exist", name));
        }
        String version = null;
        ReadStream is = path.openRead();
        try {
            is.skip(66560L);
            CharBuffer sb = new CharBuffer();
            while ((ch = is.read()) > 0) {
                sb.append((char)ch);
            }
            version = sb.toString();
            if (!version.startsWith("Resin-DB")) {
                throw new SQLException(L.l("table {0} is not a Resin DB.  Version '{1}'", (Object)name, version));
            }
            if (version.compareTo("Resin-DB 3.0.15") < 0 || "Resin-DB 3.0.15".compareTo(version) < 0) {
                throw new SQLException(L.l("table {0} is out of date.  Old version {1}.", (Object)name, version));
            }
        }
        finally {
            is.close();
        }
        is = path.openRead();
        try {
            is.skip(67584L);
            CharBuffer cb = new CharBuffer();
            while ((ch = is.read()) > 0) {
                cb.append((char)ch);
            }
            String sql = cb.toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer(new CharBuffer().append("Table[").append(name).append("] ").append(version).append(" loading\n").append(sql).toString());
            }
            try {
                CreateQuery query = (CreateQuery)Parser.parse(db, sql);
                TableFactory factory = query.getFactory();
                if (!factory.getName().equalsIgnoreCase(name)) {
                    throw new IOException(L.l("factory {0} does not match", name));
                }
                Table table = new Table(db, factory.getName(), factory.getRow(), factory.getConstraints());
                table.init();
                table.clearIndexes();
                table.initIndexes();
                table.rebuildIndexes();
                Table table2 = table;
                return table2;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                log.warning(e.toString());
                throw new SQLException(L.l("can't load table {0} in {1}.\n{2}", name, path.getNativePath(), e.toString()));
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws IOException, SQLException {
        super.create();
        this.initIndexes();
        byte[] tempBuffer = new byte[65536];
        this.readBlock(65536L, tempBuffer, 0, 65536);
        TempStream ts = new TempStream();
        WriteStream os = new WriteStream(ts);
        try {
            for (int i = 0; i < 1024; ++i) {
                os.write(tempBuffer[i]);
            }
            this.writeTableHeader(os);
        }
        finally {
            os.close();
        }
        int offset = 0;
        for (TempBuffer head = ts.getHead(); head != null; head = head.getNext()) {
            int length;
            byte[] buffer = head.getBuffer();
            System.arraycopy(buffer, 0, tempBuffer, offset, length);
            for (length = head.getLength(); length < buffer.length; ++length) {
                tempBuffer[offset + length] = 0;
            }
            offset += buffer.length;
        }
        while (offset < 65536) {
            tempBuffer[offset] = 0;
            ++offset;
        }
        this.writeBlock(65536L, tempBuffer, 0, 65536);
        this._database.addTable(this);
    }

    private void initIndexes() throws IOException, SQLException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            KeyCompare keyCompare;
            Column column = columns[i];
            if (!column.isUnique() || (keyCompare = column.getIndexKeyCompare()) == null) continue;
            Block rootBlock = this.allocateIndexBlock();
            long rootBlockId = rootBlock.getBlockId();
            rootBlock.free();
            BTree btree = new BTree(this, rootBlockId, column.getLength(), keyCompare);
            column.setIndex(btree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void clearIndexes() throws IOException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            BTree index = columns[i].getIndex();
            if (index == null) continue;
            long rootAddr = index.getIndexRoot();
            Block block = this.readBlock(this.addressToBlockId(rootAddr));
            try {
                byte[] blockBuffer;
                byte[] byArray = blockBuffer = block.getBuffer();
                // MONITORENTER : blockBuffer
                for (int j = 0; j < blockBuffer.length; ++j) {
                    blockBuffer[j] = 0;
                }
                block.setDirty(0, 65536);
                // MONITOREXIT : byArray
                continue;
            }
            finally {
                block.free();
            }
        }
        long blockAddr = 0L;
        while ((blockAddr = this.firstBlock(blockAddr + 65536L, 4)) > 0L) {
            this.freeBlock(blockAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndexes() throws IOException, SQLException {
        Transaction xa = Transaction.create();
        xa.setAutoCommit(true);
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(xa);
            Column[] columns = this._row.getColumns();
            while (iter.next()) {
                iter.prevRow();
                byte[] blockBuffer = iter.getBuffer();
                while (iter.nextRow()) {
                    long rowAddress = iter.getRowAddress();
                    int rowOffset = iter.getRowOffset();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        column.setIndex(xa, blockBuffer, rowOffset, rowAddress, null);
                    }
                }
            }
        }
        finally {
            xa.commit();
        }
    }

    private void writeTableHeader(WriteStream os) throws IOException {
        int i;
        os.print("Resin-DB 3.0.15");
        os.write(0);
        while (os.getBufferOffset() < 1056) {
            os.write(0);
        }
        Column[] columns = this._row.getColumns();
        for (i = 0; i < columns.length; ++i) {
            if (!columns[i].isUnique()) continue;
            BTree index = columns[i].getIndex();
            if (index != null) {
                this.writeLong(os, index.getIndexRoot());
                continue;
            }
            this.writeLong(os, 0L);
        }
        while (os.getBufferOffset() < 2048) {
            os.write(0);
        }
        os.print(new CharBuffer().append("CREATE TABLE ").append(this.getName()).append("(").toString());
        for (i = 0; i < this._row.getColumns().length; ++i) {
            Expr defaultExpr;
            Column column = this._row.getColumns()[i];
            if (i != 0) {
                os.print(",");
            }
            os.print(column.getName());
            os.print(" ");
            switch (column.getTypeCode()) {
                case 1: {
                    os.print(new CharBuffer().append("VARCHAR(").append(column.getDeclarationSize()).append(")").toString());
                    break;
                }
                case 2: {
                    os.print("INTEGER");
                    break;
                }
                case 3: {
                    os.print("BIGINT");
                    break;
                }
                case 4: {
                    os.print("DOUBLE");
                    break;
                }
                case 5: {
                    os.print("TIMESTAMP");
                    break;
                }
                case 6: {
                    os.print("BLOB");
                    break;
                }
                case 7: {
                    NumericColumn numeric = (NumericColumn)column;
                    os.print(new CharBuffer().append("NUMERIC(").append(numeric.getPrecision()).append(",").append(numeric.getScale()).append(")").toString());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (column.isPrimaryKey()) {
                os.print(" PRIMARY KEY");
            } else if (column.isUnique()) {
                os.print(" UNIQUE");
            }
            if (column.isNotNull()) {
                os.print(" NOT NULL");
            }
            if ((defaultExpr = column.getDefault()) != null) {
                os.print(" DEFAULT (");
                os.print(defaultExpr);
                os.print(")");
            }
            if (column.getAutoIncrement() < 0) continue;
            os.print(" auto_increment");
        }
        os.print(")");
    }

    public TableIterator createTableIterator() {
        this.assertStoreActive();
        return new TableIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextAutoIncrement(QueryContext context) throws SQLException {
        Table table = this;
        synchronized (table) {
            if (this._autoIncrementValue >= 0L) {
                return ++this._autoIncrementValue;
            }
        }
        long max = 0L;
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(context);
            while (iter.next()) {
                iter.prevRow();
                byte[] buffer = iter.getBuffer();
                while (iter.nextRow()) {
                    long value = this._autoIncrementColumn.getLong(buffer, iter.getRowOffset());
                    if (max >= value) continue;
                    max = value;
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        Table table2 = this;
        synchronized (table2) {
            if (this._autoIncrementValue < max) {
                this._autoIncrementValue = max;
            }
            return ++this._autoIncrementValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(QueryContext queryContext, Transaction xa, ArrayList<Column> columns, ArrayList<Expr> values) throws IOException, SQLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append("db table ").append(this.getName()).append(" insert row xa:").append(xa).toString());
        }
        TableIterator iter = this.createTableIterator();
        TableIterator[] iterSet = new TableIterator[]{iter};
        queryContext.init(xa, iterSet);
        iter.init(queryContext);
        boolean isLoop = false;
        while (true) {
            Block block = null;
            try {
                long addr;
                block21: {
                    int n;
                    int rowOffset;
                    addr = this._rowClockAddr;
                    long blockId = this.firstRow(addr);
                    if (blockId < 0L) {
                        if (!isLoop && 1024L < this._rowClockTotal && 4L * this._rowClockUsed < 3L * this._rowClockTotal) {
                            isLoop = true;
                            this._rowClockAddr = 0L;
                            this._rowClockUsed = 0L;
                            this._rowClockTotal = 0L;
                            continue;
                        }
                        block = xa.allocateRow(this);
                        blockId = block.getBlockId();
                        addr = Table.blockIdToAddress(blockId);
                        this._rowClockAddr = 0L;
                        this._rowClockUsed = 0L;
                        this._rowClockTotal = 0L;
                        rowOffset = 0;
                    } else if (blockId == this.addressToBlockId(addr)) {
                        rowOffset = (int)(addr & 0xFFFFL);
                    } else {
                        rowOffset = 0;
                        addr = this._rowClockAddr = Table.blockIdToAddress(blockId);
                    }
                    int nextRowOffset = rowOffset + this._rowLength;
                    if (this._rowEnd <= nextRowOffset) {
                        nextRowOffset = 65536;
                    }
                    this._rowClockAddr = (this._rowClockAddr & 0xFFFFFFFFFFFF0000L) + (long)nextRowOffset;
                    ++this._rowClockTotal;
                    if (block == null) {
                        block = xa.readBlock(this, blockId);
                    }
                    if ((block.getBuffer()[rowOffset] & 1) == 1) {
                        ++this._rowClockUsed;
                        continue;
                    }
                    WriteBlock writeBlock = xa.createWriteBlock(block);
                    block = writeBlock;
                    byte[] buffer = writeBlock.getBuffer();
                    long rowAddr = Table.blockIdToAddress(writeBlock.getBlockId(), rowOffset);
                    boolean isOkay = false;
                    try {
                        long value;
                        Expr value2;
                        Column column;
                        int i;
                        iter.setRow(writeBlock, rowOffset);
                        for (i = 0; i < columns.size(); ++i) {
                            column = columns.get(i);
                            value2 = values.get(i);
                            column.setExpr(xa, buffer, rowOffset, value2, queryContext);
                        }
                        writeBlock.setDirty(rowOffset, nextRowOffset);
                        int n2 = rowOffset;
                        buffer[n2] = (byte)(buffer[n2] | 1);
                        this.validate(writeBlock, rowOffset, queryContext, xa);
                        for (i = 0; i < columns.size(); ++i) {
                            column = columns.get(i);
                            value2 = values.get(i);
                            column.setIndex(xa, buffer, rowOffset, rowAddr, queryContext);
                        }
                        if (this._autoIncrementColumn != null && this._autoIncrementValue < (value = this._autoIncrementColumn.getLong(buffer, rowOffset))) {
                            this._autoIncrementValue = value;
                        }
                        if (isOkay = true) break block21;
                        n = rowOffset;
                    }
                    catch (Throwable throwable) {
                        if (!isOkay) {
                            int n3 = rowOffset;
                            buffer[n3] = (byte)(buffer[n3] & 0xFFFFFFFE);
                        }
                        throw throwable;
                    }
                    buffer[n] = (byte)(buffer[n] & 0xFFFFFFFE);
                }
                ++this._entries;
                long l = addr;
                return l;
            }
            finally {
                if (block == null) continue;
                block.free();
                continue;
            }
            break;
        }
    }

    private void validate(Block block, int rowOffset, QueryContext queryContext, Transaction xa) throws SQLException {
        TableIterator row = this.createTableIterator();
        TableIterator[] rows = new TableIterator[]{row};
        row.setRow(block, rowOffset);
        for (int i = 0; i < this._constraints.length; ++i) {
            this._constraints[i].validate(rows, queryContext, xa);
        }
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].delete(xa, block, rowOffset);
        }
        block[rowOffset] = 0;
    }

    private void writeLong(WriteStream os, long value) throws IOException {
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    private void setLong(byte[] buffer, int offset, long value) throws IOException {
        buffer[offset + 0] = (byte)(value >> 56);
        buffer[offset + 1] = (byte)(value >> 48);
        buffer[offset + 2] = (byte)(value >> 40);
        buffer[offset + 3] = (byte)(value >> 32);
        buffer[offset + 4] = (byte)(value >> 24);
        buffer[offset + 5] = (byte)(value >> 16);
        buffer[offset + 6] = (byte)(value >> 8);
        buffer[offset + 7] = (byte)value;
    }

    private long getLong(byte[] buffer, int offset) throws IOException {
        long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
        return value;
    }

    @Override
    public String toString() {
        return new CharBuffer().append("Table[").append(this.getName()).append(":").append(this.getId()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.table.Table");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

