/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Transaction;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.ClockCacheItem;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Lock
implements ClockCacheItem {
    private static final L10N L = new L10N(Lock._resin_compat_class_0());
    private static final Logger log = Log.open(Lock._resin_compat_class_0());
    private final long _id;
    private int _readCount;
    private int _upgradeCount;
    private int _writeCount;
    private boolean _isUsed;
    private ArrayList<Transaction> _queue;
    private Transaction _xa;
    private static Class _resin_compat_class_0;

    public Lock(long id) {
        this._id = id;
    }

    public long getId() {
        return this._id;
    }

    synchronized void lockRead(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("LockRead$").append(System.identityHashCode(this)).append("[").append(this._id).append("] read:").append(this._readCount).append(" upgrade:").append(this._upgradeCount).toString());
        }
        if (this._upgradeCount == 0) {
            ++this._readCount;
        } else if (this.queue(xa, Alarm.getCurrentTime() + timeout)) {
            ++this._readCount;
            this.wake();
        } else {
            throw new SQLException(L.l("can't obtain read only lock"));
        }
    }

    synchronized void lockReadOnly(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("LockRead[").append(this._id).append("] read:").append(this._readCount).append(" upgrade:").append(this._upgradeCount).toString());
        }
        if (this._writeCount == 0) {
            ++this._readCount;
        } else if (this.queue(xa, Alarm.getCurrentTime() + timeout)) {
            ++this._readCount;
            this.wake();
        } else {
            throw new SQLException(L.l("can't obtain read only lock"));
        }
    }

    synchronized void unlockRead() throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("UnlockRead[").append(this._id).append("] read:").append(this._readCount).append(" write:").append(this._writeCount).toString());
        }
        --this._readCount;
        if (this._readCount < 0) {
            Thread.dumpStack();
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockUpgrade(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("LockUpgrade[").append(this._id).append("] read:").append(this._readCount).append(" upgrade:").append(this._upgradeCount).toString());
        }
        ++this._upgradeCount;
        long expire = Alarm.getCurrentTime() + timeout;
        try {
            boolean isFirst = true;
            while (this._readCount != 1) {
                this.queue(xa, expire);
                isFirst = false;
            }
        }
        finally {
            if (this._readCount != 1) {
                this.unlockUpgradeInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockReadAndUpgrade(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("LockUpgrade[").append(this._id).append("] read:").append(this._readCount).append(" upgrade:").append(this._upgradeCount).toString());
        }
        ++this._upgradeCount;
        long expire = Alarm.getCurrentTime() + timeout;
        boolean isOkay = false;
        try {
            while (this._readCount != 0) {
                this.queue(xa, expire);
            }
            isOkay = true;
        }
        finally {
            if (isOkay) {
                this._readCount = 1;
            } else {
                this.unlockUpgradeInt();
            }
        }
    }

    synchronized void unlockUpgrade() throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("UnlockUpgrade[").append(this._id).append("] read:").append(this._readCount).append(" upgrade:").append(this._upgradeCount).toString());
        }
        this.unlockUpgradeInt();
    }

    private void unlockUpgradeInt() throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("UnlockUpgradeInt[").append(this._id).append("] read:").append(this._readCount).append(" upgrade:").append(this._upgradeCount).toString());
        }
        --this._upgradeCount;
        if (this._upgradeCount < 0) {
            IllegalStateException e = new IllegalStateException(new CharBuffer().append("Illegal upgrade count: ").append(this._upgradeCount).toString());
            e.fillInStackTrace();
            log.log(Level.WARNING, e.toString(), e);
            this._upgradeCount = 0;
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockWrite(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("LockWrite[").append(this._id).append("] read:").append(this._readCount).append(" write:").append(this._writeCount).toString());
        }
        if (this._writeCount > 0) {
            throw new IllegalStateException(L.l("multiple write locks"));
        }
        if (this._upgradeCount == 0) {
            throw new IllegalStateException(L.l("no upgrade obtained for write"));
        }
        ++this._writeCount;
        long expire = Alarm.getCurrentTime() + timeout;
        boolean isOkay = false;
        try {
            boolean isFirst = true;
            while (this._readCount != 1) {
                this.queue(xa, expire);
                isFirst = false;
            }
            isOkay = true;
        }
        finally {
            if (!isOkay) {
                this.unlockWriteInt();
            }
        }
    }

    synchronized void unlockWrite() throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("UnlockWrite[").append(this._id).append("] read:").append(this._readCount).append(" write:").append(this._writeCount).toString());
        }
        this.unlockWriteInt();
    }

    private void unlockWriteInt() throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new CharBuffer().append("UnlockWriteInt[").append(this._id).append("] read:").append(this._readCount).append(" write:").append(this._writeCount).toString());
        }
        --this._writeCount;
        if (this._writeCount < 0) {
            this._writeCount = 0;
            Thread.dumpStack();
        }
        this.wake();
    }

    private boolean queue(Transaction xa, long expireTime) throws SQLException {
        return this.queue(xa, expireTime, false);
    }

    /*
     * Exception decompiling
     */
    private boolean queue(Transaction xa, long expireTime, boolean isLifo) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean wake() {
        try {
            if (this._queue == null || this._queue.size() == 0 || this._xa != null) {
                return false;
            }
            this._xa = this._queue.remove(0);
            this.notifyAll();
            return true;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return true;
        }
    }

    public void clearUsed() {
        this._isUsed = false;
    }

    public void setUsed() {
        this._isUsed = true;
    }

    public synchronized boolean isUsed() {
        return this._isUsed || this._readCount > 0 || this._upgradeCount > 0;
    }

    public void removeEvent() {
    }

    public String toString() {
        return new CharBuffer().append("Lock$").append(System.identityHashCode(this)).append("[").append(this._id).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.store.Lock");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

