/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.caucho.util.CacheListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.ClockCacheItem;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Block
implements ClockCacheItem,
CacheListener {
    private static final Logger log = Log.open(Block._resin_compat_class_0());
    private static final L10N L = new L10N(Block._resin_compat_class_0());
    protected static final FreeList<byte[]> _freeBuffers = new FreeList(4);
    private final Store _store;
    private final long _blockId;
    private int _useCount;
    private boolean _isFlushDirtyOnCommit;
    private boolean _isValid;
    private int _dirtyMin = 65536;
    private int _dirtyMax;
    private static Class _resin_compat_class_0;

    Block(Store store, long blockId) {
        store.validateBlockId(blockId);
        this._store = store;
        this._blockId = blockId;
        this._isFlushDirtyOnCommit = this._store.isFlushDirtyBlocksOnCommit();
        if (log.isLoggable(Level.FINER)) {
            log.finer(new CharBuffer().append(this).append(" create").toString());
        }
    }

    public boolean isFlushDirtyOnCommit() {
        return this._isFlushDirtyOnCommit;
    }

    public void setFlushDirtyOnCommit(boolean isFlush) {
        this._isFlushDirtyOnCommit = isFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allocate() {
        Block block = this;
        synchronized (block) {
            if (this.getBuffer() == null) {
                return false;
            }
            ++this._useCount;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(new CharBuffer().append(this).append(" allocate").toString());
            }
            if (this._useCount > 32 && log.isLoggable(Level.FINE)) {
                Thread.dumpStack();
                log.fine(new CharBuffer().append("using ").append(this).append(" ").append(this._useCount).append(" times").toString());
            }
        }
        return true;
    }

    Store getStore() {
        return this._store;
    }

    public long getBlockId() {
        return this._blockId;
    }

    public abstract byte[] getBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        Block block = this;
        synchronized (block) {
            if (!this._isValid) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(new CharBuffer().append("read db-block ").append(this).toString());
                }
                this._store.readBlock(this._blockId & 0xFFFFFFFFFFFF0000L, this.getBuffer(), 0, 65536);
                this._isValid = true;
                this._dirtyMin = 65536;
                this._dirtyMax = 0;
            }
        }
    }

    public void commit() throws IOException {
        if (!this._isFlushDirtyOnCommit) {
            return;
        }
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        Block block = this;
        synchronized (block) {
            int dirtyMin = this._dirtyMin;
            this._dirtyMin = 65536;
            int dirtyMax = this._dirtyMax;
            this._dirtyMax = 0;
            if (dirtyMin < dirtyMax) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(new CharBuffer().append("write db-block ").append(this).append(" [").append(dirtyMin).append(", ").append(dirtyMax).append("]").toString());
                }
                this.writeImpl(dirtyMin, dirtyMax - dirtyMin);
            } else if (log.isLoggable(Level.FINER)) {
                log.finer(new CharBuffer().append("not-dirty db-block ").append(this).toString());
            }
            this._isValid = true;
        }
    }

    protected void writeImpl(int offset, int length) throws IOException {
        this._store.writeBlock((this._blockId & 0xFFFFFFFFFFFF0000L) + (long)offset, this.getBuffer(), offset, length);
    }

    public void invalidate() {
        if (this._dirtyMin < this._dirtyMax) {
            throw new IllegalStateException();
        }
        this._isValid = false;
        this._dirtyMin = 65536;
        this._dirtyMax = 0;
    }

    void validate() {
        this._isValid = true;
    }

    public void setDirty(int min, int max) {
        this._isValid = true;
        if (min < this._dirtyMin) {
            this._dirtyMin = min;
        }
        if (this._dirtyMax < max) {
            this._dirtyMax = max;
        }
    }

    public boolean isDirty() {
        return this._dirtyMin < this._dirtyMax;
    }

    public boolean isFree() {
        return this._useCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Block block = this;
        synchronized (block) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(new CharBuffer().append(this).append(" free").toString());
            }
            --this._useCount;
            if (this._useCount < 0) {
                this._useCount = 0;
                log.warning(new CharBuffer().append("db-block illegal free ").append(this).toString());
                throw new IllegalStateException();
            }
        }
    }

    public boolean isUsed() {
        return this._useCount > 0;
    }

    public void setUsed() {
    }

    public void clearUsed() {
    }

    public void removeEvent() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Block block = this;
        synchronized (block) {
            if (this._dirtyMin < this._dirtyMax) {
                try {
                    this.write();
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            this.freeImpl();
            if (log.isLoggable(Level.FINER)) {
                log.finer(new CharBuffer().append("db-block remove ").append(this).toString());
            }
        }
    }

    protected void freeImpl() {
    }

    public String toString() {
        return new CharBuffer().append("Block[").append(this._store).append(",").append(this._blockId / 65536L).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.store.Block");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

