/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Inode;
import com.caucho.db.store.RawTransaction;
import com.caucho.db.store.Store;
import com.caucho.db.store.StoreTransaction;
import com.caucho.db.store.Transaction;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class BlobOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(BlobOutputStream._resin_compat_class_0().getName());
    private StoreTransaction _xa;
    private Store _store;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _offset;
    private int _bufferEnd;
    private Inode _inode;
    private byte[] _inodeBuffer;
    private int _inodeOffset;
    private static Class _resin_compat_class_0;

    public BlobOutputStream(Transaction xa, Store store, byte[] inode, int inodeOffset) {
        this.init(store, inode, inodeOffset);
        this._xa = xa;
    }

    public BlobOutputStream(Store store, byte[] inode, int inodeOffset) {
        this.init(store, inode, inodeOffset);
    }

    BlobOutputStream(Inode inode) {
        this.init(inode.getStore(), inode.getBuffer(), 0);
        this._inode = inode;
    }

    public void init(Store store, byte[] inode, int inodeOffset) {
        this._store = store;
        this._xa = RawTransaction.create();
        this._inodeBuffer = inode;
        this._inodeOffset = inodeOffset;
        Inode.clear(this._inodeBuffer, this._inodeOffset);
        this._offset = 0;
        this._tempBuffer = TempBuffer.allocate();
        this._buffer = this._tempBuffer.getBuffer();
        this._bufferEnd = this._buffer.length;
    }

    public void write(int v) throws IOException {
        if (this._bufferEnd <= this._offset) {
            this.flushBlock();
        }
        this._buffer[this._offset++] = (byte)v;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int sublen;
            if (this._bufferEnd <= this._offset) {
                this.flushBlock();
            }
            if (length < (sublen = this._bufferEnd - this._offset)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._buffer, this._offset, sublen);
            offset += sublen;
            this._offset += sublen;
            length -= sublen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this._tempBuffer == null) {
                return;
            }
            this.flushBlock();
        }
        finally {
            Inode inode = this._inode;
            this._inode = null;
            if (inode != null) {
                inode.closeOutputStream();
            }
            this._inodeBuffer = null;
            TempBuffer tempBuffer = this._tempBuffer;
            this._tempBuffer = null;
            if (tempBuffer != null) {
                TempBuffer.free(tempBuffer);
            }
        }
    }

    private void flushBlock() throws IOException {
        int length = this._offset;
        this._offset = 0;
        Inode.append(this._inodeBuffer, this._inodeOffset, this._store, this._xa, this._buffer, 0, length);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.store.BlobOutputStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

