/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Logger;

public class SumExpr
extends FunExpr
implements GroupExpr {
    protected static final L10N L = new L10N(SumExpr._resin_compat_class_0());
    private static final Logger log = Log.open(SumExpr._resin_compat_class_0());
    private Expr _expr;
    private int _groupField;
    private static Class _resin_compat_class_0;

    protected void addArg(Expr expr) throws SQLException {
        if (this._expr != null) {
            throw new SQLException(L.l("sum requires a single argument"));
        }
        this._expr = expr;
    }

    protected Expr bind(Query query) throws SQLException {
        this._groupField = query.getDataFields();
        query.setDataFields(this._groupField + 1);
        query.setGroup(true);
        this._expr = this._expr.bind(query);
        return this;
    }

    public Class getType() {
        if (this._expr.isLong()) {
            return Long.TYPE;
        }
        return Double.TYPE;
    }

    public void initGroup(QueryContext context) throws SQLException {
        context.setGroupDouble(this._groupField, 0.0);
    }

    public void evalGroup(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return;
        }
        double value = this._expr.evalDouble(context);
        double oldValue = context.getGroupDouble(this._groupField);
        context.setGroupDouble(this._groupField, value + oldValue);
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return context.isGroupNull(this._groupField);
    }

    public double evalDouble(QueryContext context) throws SQLException {
        return context.getGroupDouble(this._groupField);
    }

    public long evalLong(QueryContext context) throws SQLException {
        return (long)this.evalDouble(context);
    }

    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.SumExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

