/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringExpr
extends Expr {
    private static final Logger log = Log.open(StringExpr._resin_compat_class_1());
    private String _value;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    StringExpr(String value) {
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public Class getType() {
        return StringExpr._resin_compat_class_0();
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._value == null;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return this._value;
    }

    public String toString() {
        return new CharBuffer().append("'").append(this._value).append("'").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.db.sql.StringExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

