/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.AndExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.OidExpr;
import com.caucho.db.sql.ParamExpr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.sql.SubSelectExpr;
import com.caucho.db.sql.SubSelectParamExpr;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query {
    private static final Logger log = Log.open(Query._resin_compat_class_0());
    private static final L10N L = new L10N(Query._resin_compat_class_0());
    private Database _db;
    private String _sql;
    private FromItem[] _fromItems;
    private ParamExpr[] _params;
    private boolean _isGroup;
    private int _dataFieldCount;
    private Query _parent;
    private SubSelectExpr _parentSubSelect;
    private Expr[] _whereExprs;
    protected Expr _whereExpr;
    private RowIterateExpr[] _indexExprs;
    private ArrayList<SubSelectParamExpr> _paramExprs = new ArrayList();
    private static Class _resin_compat_class_0;

    protected Query(Database db, String sql) {
        this._db = db;
        this._sql = sql;
    }

    protected Query(Database db, String sql, FromItem[] fromItems) {
        this._db = db;
        this._sql = sql;
        this._fromItems = fromItems;
    }

    public Database getDatabase() {
        return this._db;
    }

    public void setParent(Query query) {
        this._parent = query;
    }

    public Query getParent() {
        return this._parent;
    }

    public void setSubSelect(SubSelectExpr subSelect) {
        this._parentSubSelect = subSelect;
    }

    public SubSelectExpr getSubSelect() {
        return this._parentSubSelect;
    }

    public int getDataFields() {
        return this._dataFieldCount;
    }

    public void setDataFields(int fieldCount) {
        this._dataFieldCount = fieldCount;
    }

    public FromItem[] getFromItems() {
        return this._fromItems;
    }

    protected void setFromItems(FromItem[] fromItems) {
        this._fromItems = fromItems;
    }

    protected void setFromItems(ArrayList<FromItem> fromItems) {
        this._fromItems = new FromItem[fromItems.size()];
        fromItems.toArray(this._fromItems);
    }

    public void setWhereExpr(Expr expr) {
        this._whereExpr = expr;
    }

    public Expr[] getWhereExprs() {
        return this._whereExprs;
    }

    protected void setWhereExprs(Expr[] whereExprs) {
        this._whereExprs = whereExprs;
    }

    public void setParams(ParamExpr[] params) {
        this._params = params;
    }

    public ArrayList<SubSelectParamExpr> getParamExprs() {
        return this._paramExprs;
    }

    String getSQL() {
        return this._sql;
    }

    public boolean isSelect() {
        return false;
    }

    public void setGroup(boolean isGroup) {
        this._isGroup = isGroup;
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    protected void bind() throws SQLException {
        Expr expr;
        int i;
        if (this._whereExpr != null) {
            this.generateWhere(this._whereExpr);
            for (i = 0; i < this._whereExprs.length; ++i) {
                expr = this._whereExprs[i];
                if (expr == null) continue;
                this._whereExprs[i] = expr.bind(this);
            }
        } else if (this._fromItems != null) {
            this._whereExprs = new Expr[this._fromItems.length + 1];
            this._indexExprs = new RowIterateExpr[this._fromItems.length];
        } else {
            this._whereExprs = new Expr[2];
            this._indexExprs = new RowIterateExpr[1];
        }
        for (i = 0; i < this._indexExprs.length; ++i) {
            expr = this._indexExprs[i];
            this._indexExprs[i] = expr == null ? new RowIterateExpr() : (RowIterateExpr)this._indexExprs[i].bind(this);
        }
        for (i = 0; i < this._paramExprs.size(); ++i) {
            expr = this._paramExprs.get(i);
            expr = (SubSelectParamExpr)((SubSelectParamExpr)expr).bind(this._parent);
            this._paramExprs.set(i, (SubSelectParamExpr)expr);
        }
    }

    protected void generateWhere(Expr whereExpr) throws SQLException {
        int i;
        ArrayList<Expr> andProduct = new ArrayList<Expr>();
        whereExpr.splitAnd(andProduct);
        FromItem[] fromItems = this.getFromItems();
        Expr[] whereExprs = new Expr[fromItems.length + 1];
        RowIterateExpr[] indexExprs = new RowIterateExpr[fromItems.length];
        this._whereExprs = whereExprs;
        this._indexExprs = indexExprs;
        ArrayList<FromItem> costItems = new ArrayList<FromItem>();
        this.orderFromItems(costItems, andProduct);
        costItems.clear();
        for (i = fromItems.length; i >= 0; --i) {
            long bestCost;
            if (i < fromItems.length) {
                costItems.add(fromItems[i]);
            }
            AndExpr subWhereExpr = null;
            boolean hasExpr = false;
            int bestIndex = -1;
            do {
                bestCost = Long.MAX_VALUE;
                for (int j = andProduct.size() - 1; j >= 0; --j) {
                    Expr subExpr = andProduct.get(j);
                    long cost = subExpr.cost(costItems);
                    if (Integer.MAX_VALUE <= cost && i != 0 || cost >= bestCost) continue;
                    bestCost = cost;
                    bestIndex = j;
                }
                if (bestCost >= Long.MAX_VALUE) continue;
                Expr expr = andProduct.remove(bestIndex);
                RowIterateExpr indexExpr = null;
                if (i < fromItems.length) {
                    indexExpr = expr.getIndexExpr(fromItems[i]);
                }
                if (indexExpr != null && indexExprs[i] == null) {
                    indexExprs[i] = indexExpr;
                    continue;
                }
                if (subWhereExpr == null) {
                    subWhereExpr = new AndExpr();
                }
                subWhereExpr.add(expr);
            } while (bestCost < Long.MAX_VALUE);
            if (subWhereExpr == null) continue;
            whereExprs[i] = subWhereExpr.getSingleExpr();
        }
        for (i = 0; i < whereExprs.length; ++i) {
            Expr expr;
            whereExprs[i] = expr = whereExprs[i];
        }
        this._whereExprs = whereExprs;
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append("where-").append(whereExprs.length - 1).append(": static ").append(whereExprs[whereExprs.length - 1]).toString());
            for (i = whereExprs.length - 2; i >= 0; --i) {
                if (this._indexExprs[i] != null) {
                    log.fine(new CharBuffer().append("index-").append(i).append(": ").append(this._fromItems[i]).append(" ").append(this._indexExprs[i]).toString());
                }
                log.fine(new CharBuffer().append("where-").append(i).append(": ").append(this._fromItems[i]).append(" ").append(whereExprs[i]).toString());
            }
        }
    }

    private void orderFromItems(ArrayList<FromItem> costItems, ArrayList<Expr> topAndProduct) {
        FromItem[] fromItems = this.getFromItems();
        ArrayList<Expr> andProduct = new ArrayList<Expr>(topAndProduct);
        for (int i = fromItems.length - 1; i >= 0; --i) {
            costItems.clear();
            for (int j = i + 1; j < fromItems.length; ++j) {
                costItems.add(fromItems[j]);
            }
            int bestIndex = i;
            long bestCost = 9223372036854775L;
            block2: for (int j = 0; j <= i; ++j) {
                FromItem item = fromItems[j];
                costItems.add(item);
                for (int k = 0; k < fromItems.length; ++k) {
                    if (fromItems[k].isValid(costItems)) continue;
                    costItems.remove(costItems.size() - 1);
                    continue block2;
                }
                long cost = Long.MAX_VALUE;
                for (int k = 0; k < andProduct.size(); ++k) {
                    Expr expr = andProduct.get(k);
                    long subCost = expr.cost(costItems);
                    if (9223372036854775L <= subCost) {
                        costItems.remove(costItems.size() - 1);
                        continue block2;
                    }
                    if (subCost >= cost) continue;
                    cost = subCost;
                }
                costItems.remove(costItems.size() - 1);
                if (cost >= bestCost) continue;
                bestCost = cost;
                bestIndex = j;
            }
            FromItem tempItem = fromItems[i];
            fromItems[i] = fromItems[bestIndex];
            fromItems[bestIndex] = tempItem;
            costItems.add(fromItems[i]);
            for (int k = andProduct.size() - 1; k >= 0; --k) {
                Expr expr = andProduct.get(k);
                long subCost = expr.cost(costItems);
                if (subCost >= Integer.MAX_VALUE) continue;
                andProduct.remove(k);
            }
        }
    }

    private String logWhere() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("[");
        for (int i = 0; i < this._whereExprs.length; ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            if (this._whereExprs[i] == null) continue;
            cb.append(this._whereExprs[i]);
        }
        cb.append("]");
        return cb.close();
    }

    protected Expr bind(String tableName, String columnName) throws SQLException {
        FromItem[] fromItems = this.getFromItems();
        if (tableName == null) {
            if ("resin_oid".equals(columnName)) {
                return new OidExpr(fromItems[0].getTable(), 0);
            }
            for (int i = 0; i < fromItems.length; ++i) {
                Table table = fromItems[i].getTable();
                int columnIndex = table.getColumnIndex(columnName);
                if (columnIndex < 0) continue;
                Column column = table.getColumn(columnName);
                return new IdExpr(fromItems[i], column);
            }
            Expr expr = this.bindParent(tableName, columnName);
            if (expr != null) {
                return expr;
            }
            throw new SQLException(L.l("`{0}' is an unknown column.", columnName));
        }
        for (int i = 0; i < fromItems.length; ++i) {
            if (!tableName.equals(fromItems[i].getName())) continue;
            Table table = fromItems[i].getTable();
            if ("resin_oid".equals(columnName)) {
                return new OidExpr(table, i);
            }
            int columnIndex = table.getColumnIndex(columnName);
            if (columnIndex < 0) {
                Expr expr = this.bindParent(tableName, columnName);
                if (expr != null) {
                    return expr;
                }
                throw new SQLException(L.l("`{0}' is an unknown column in \n  {1}.", (Object)columnName, this._sql));
            }
            Column column = table.getColumn(columnName);
            return new IdExpr(fromItems[i], column);
        }
        Expr expr = this.bindParent(tableName, columnName);
        if (expr != null) {
            return expr;
        }
        throw new SQLException(L.l("`{0}' is an unknown table.\n{1}", (Object)tableName, this.getSQL()));
    }

    private Expr bindParent(String tableName, String columnName) throws SQLException {
        Expr expr;
        if (this._parent != null && (expr = this._parent.bind(tableName, columnName)) != null) {
            SubSelectParamExpr paramExpr = new SubSelectParamExpr(this, expr, this._paramExprs.size());
            this._paramExprs.add(paramExpr);
            return paramExpr;
        }
        return null;
    }

    public void clearParameters() {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].clear();
        }
    }

    public void setBoolean(int index, boolean value) {
        this._params[index - 1].setBoolean(value);
    }

    public void setString(int index, String value) {
        this._params[index - 1].setString(value);
    }

    public void setLong(int index, long value) {
        this._params[index - 1].setLong(value);
    }

    public void setDouble(int index, double value) {
        this._params[index - 1].setDouble(value);
    }

    public void setDate(int index, long value) {
        this._params[index - 1].setDate(value);
    }

    public void setBinaryStream(int index, InputStream is, int length) {
        this._params[index - 1].setBinaryStream(is, length);
    }

    public abstract void execute(QueryContext var1, Transaction var2) throws SQLException;

    protected boolean start(TableIterator[] rows, int rowLength, QueryContext queryContext, Transaction xa) throws SQLException {
        try {
            Expr[] whereExprs = this._whereExprs;
            if (whereExprs != null && whereExprs[rowLength] != null && !whereExprs[rowLength].isSelect(queryContext)) {
                return false;
            }
            if (rowLength == 0) {
                return true;
            }
            for (int i = rowLength - 1; i >= 0; --i) {
                RowIterateExpr iterExpr = this._indexExprs[i];
                TableIterator row = rows[i];
                if (!iterExpr.init(queryContext, row)) {
                    return false;
                }
                if (xa.isAutoCommit()) continue;
                xa.lockRead(row.getTable().getLock());
            }
            return this.initBlockRow(rowLength - 1, rows, queryContext) || this.nextBlock(rowLength - 1, rows, rowLength, queryContext);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    protected boolean nextTuple(TableIterator[] rows, int rowLength, QueryContext queryContext, Transaction xa) throws SQLException {
        try {
            if (rowLength == 0) {
                return false;
            }
            RowIterateExpr[] indexExprs = this._indexExprs;
            Expr[] whereExprs = this._whereExprs;
            for (int i = 0; i < rowLength; ++i) {
                Expr whereExpr;
                TableIterator table = rows[i];
                RowIterateExpr indexExpr = indexExprs[i];
                Expr expr = whereExpr = whereExprs == null ? null : whereExprs[i];
                while (indexExpr.nextRow(queryContext, table)) {
                    if (whereExpr != null && !whereExpr.isSelect(queryContext) || i != 0 && !this.initBlockRow(i - 1, rows, queryContext)) continue;
                    return true;
                }
            }
            return this.nextBlock(rowLength - 1, rows, rowLength, queryContext);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private boolean nextBlock(int i, TableIterator[] rows, int rowLength, QueryContext queryContext) throws IOException, SQLException {
        TableIterator rowIter = rows[i];
        RowIterateExpr iterExpr = this._indexExprs[i];
        do {
            if (i > 0 && this.nextBlock(i - 1, rows, rowLength, queryContext)) {
                return true;
            }
            if (!iterExpr.nextBlock(queryContext, rowIter)) {
                return false;
            }
            if (!iterExpr.allowChildRowShift(queryContext, rows[i])) {
                return false;
            }
            for (int j = i - 1; j >= 0; --j) {
                if (iterExpr.init(queryContext, rows[j])) continue;
                return false;
            }
        } while (!this.initBlockRow(rowLength - 1, rows, queryContext));
        return true;
    }

    private boolean initBlockRow(int i, TableIterator[] rows, QueryContext queryContext) throws IOException, SQLException {
        RowIterateExpr iterExpr = this._indexExprs[i];
        Expr[] whereExprs = this._whereExprs;
        Expr expr = whereExprs == null ? null : whereExprs[i];
        TableIterator rowIter = rows[i];
        if (!iterExpr.initRow(queryContext, rowIter)) {
            return false;
        }
        while (expr != null && !expr.isSelect(queryContext) || i > 0 && !this.initBlockRow(i - 1, rows, queryContext)) {
            if (iterExpr.nextRow(queryContext, rowIter)) continue;
            return false;
        }
        return true;
    }

    protected void freeRows(TableIterator[] rows, int rowLength) {
        --rowLength;
        while (rowLength >= 0) {
            if (rows[rowLength] != null) {
                rows[rowLength].free();
            }
            --rowLength;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.Query");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

