/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.AndExpr;
import com.caucho.db.sql.AvgExpr;
import com.caucho.db.sql.BetweenExpr;
import com.caucho.db.sql.BinaryExpr;
import com.caucho.db.sql.BooleanLiteralExpr;
import com.caucho.db.sql.CmpExpr;
import com.caucho.db.sql.ConcatExpr;
import com.caucho.db.sql.CountExpr;
import com.caucho.db.sql.CreateQuery;
import com.caucho.db.sql.DeleteQuery;
import com.caucho.db.sql.DropQuery;
import com.caucho.db.sql.EqExpr;
import com.caucho.db.sql.ExistsEvalExpr;
import com.caucho.db.sql.ExistsExpr;
import com.caucho.db.sql.ExistsQuery;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.GroupResultExpr;
import com.caucho.db.sql.InExpr;
import com.caucho.db.sql.InsertQuery;
import com.caucho.db.sql.IsNullExpr;
import com.caucho.db.sql.LeftOuterJoinExpr;
import com.caucho.db.sql.LikeExpr;
import com.caucho.db.sql.MaxExpr;
import com.caucho.db.sql.MinExpr;
import com.caucho.db.sql.NotExpr;
import com.caucho.db.sql.NullExpr;
import com.caucho.db.sql.NumberExpr;
import com.caucho.db.sql.OrExpr;
import com.caucho.db.sql.Order;
import com.caucho.db.sql.ParamExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.SQLParseException;
import com.caucho.db.sql.SelectQuery;
import com.caucho.db.sql.SetItem;
import com.caucho.db.sql.StringExpr;
import com.caucho.db.sql.SubSelectEvalExpr;
import com.caucho.db.sql.SubSelectExpr;
import com.caucho.db.sql.SumExpr;
import com.caucho.db.sql.TempQuery;
import com.caucho.db.sql.UnaryExpr;
import com.caucho.db.sql.UnboundStarExpr;
import com.caucho.db.sql.UpdateQuery;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableFactory;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final Logger log = Log.open(Parser._resin_compat_class_0());
    private static final L10N L = new L10N(Parser._resin_compat_class_0());
    static final int IDENTIFIER = 128;
    static final int INTEGER = 129;
    static final int LONG = 130;
    static final int DOUBLE = 131;
    static final int STRING = 132;
    static final int TRUE = 133;
    static final int FALSE = 134;
    static final int UNKNOWN = 135;
    static final int NULL = 136;
    static final int EXISTS = 137;
    static final int FROM = 138;
    static final int IN = 139;
    static final int SELECT = 140;
    static final int DISTINCT = 141;
    static final int WHERE = 141;
    static final int AS = 142;
    static final int ORDER = 143;
    static final int GROUP = 144;
    static final int BY = 145;
    static final int ASC = 146;
    static final int DESC = 147;
    static final int LIMIT = 148;
    static final int OFFSET = 149;
    static final int BETWEEN = 150;
    static final int LIKE = 151;
    static final int ESCAPE = 152;
    static final int IS = 153;
    static final int CONCAT = 154;
    static final int EQ = 155;
    static final int NE = 156;
    static final int LT = 157;
    static final int LE = 158;
    static final int GT = 159;
    static final int GE = 160;
    static final int AND = 161;
    static final int OR = 162;
    static final int NOT = 163;
    static final int ARG = 164;
    static final int CREATE = 165;
    static final int TABLE = 166;
    static final int INSERT = 167;
    static final int INTO = 168;
    static final int VALUES = 169;
    static final int DROP = 170;
    static final int UPDATE = 171;
    static final int SET = 172;
    static final int DELETE = 173;
    static final int CONSTRAINT = 174;
    static final int UNIQUE = 175;
    static final int PRIMARY = 176;
    static final int CHECK = 177;
    static final int FOREIGN = 178;
    static final int KEY = 179;
    private static final IntMap _reserved = new IntMap();
    private Database _database;
    private final String _sql;
    private final char[] _sqlChars;
    private final int _sqlLength;
    private int _parseIndex;
    private final CharBuffer _cb = new CharBuffer();
    private String _lexeme;
    private int _token;
    private ArrayList<ParamExpr> _params = new ArrayList();
    private Query _query;
    private AndExpr _andExpr;
    private static Class _resin_compat_class_0;

    private Parser(Database database, String sql) {
        this._database = database;
        this._sql = sql;
        this._sqlLength = this._sql.length();
        this._sqlChars = new char[this._sqlLength];
        this._sql.getChars(0, this._sqlLength, this._sqlChars, 0);
    }

    public static Query parse(Database database, String sql) throws SQLException {
        Parser parser = new Parser(database, sql);
        Query query = parser.parse();
        query.bind();
        return query;
    }

    public static Expr parseExpr(Database database, String sql) throws SQLException {
        Parser parser = new Parser(database, sql);
        Expr expr = parser.parseExpr();
        return expr.bind(null);
    }

    private Query parse() throws SQLException {
        int token = this.scanToken();
        switch (token) {
            case 140: {
                return this.parseSelect();
            }
            case 165: {
                return this.parseCreate();
            }
            case 167: {
                return this.parseInsert();
            }
            case 173: {
                return this.parseDelete();
            }
            case 170: {
                return this.parseDrop();
            }
            case 171: {
                return this.parseUpdate();
            }
        }
        throw new SQLParseException(L.l("unknown query at `{0}'", this.tokenName(token)));
    }

    private SelectQuery parseSelect() throws SQLException {
        return this.parseSelect(new SelectQuery(this._database, this._sql));
    }

    private SelectQuery parseSelect(SelectQuery query) throws SQLException {
        boolean distinct = false;
        int token = this.scanToken();
        if (token == 141) {
            distinct = true;
        } else {
            this._token = token;
        }
        ArrayList<Expr> resultItems = new ArrayList<Expr>();
        int startToken = this.scanToken();
        String startLexeme = this._lexeme;
        int startOffset = this._parseIndex;
        while ((token = this.scanToken()) >= 0 && token != 138) {
        }
        if (token != 138) {
            throw this.error(L.l("expected FROM at `{0}'", this.tokenName(token)));
        }
        query.setParent(this._query);
        this._query = query;
        AndExpr oldAnd = this._andExpr;
        this._andExpr = new AndExpr();
        ArrayList<FromItem> fromItems = this.parseFromItems();
        query.setFromItems(fromItems);
        int tailToken = token = this.scanToken();
        int tailOffset = this._parseIndex;
        this._token = startToken;
        this._parseIndex = startOffset;
        this._lexeme = startLexeme;
        Expr expr = this.parseSelectExpr();
        resultItems.add(expr);
        while ((token = this.scanToken()) == 44) {
            expr = this.parseSelectExpr();
            resultItems.add(expr);
        }
        this._token = tailToken;
        this._parseIndex = tailOffset;
        token = this.scanToken();
        if (token == 141) {
            this._andExpr.add(this.parseExpr());
        } else {
            this._token = token;
        }
        ParamExpr[] params = this._params.toArray(new ParamExpr[this._params.size()]);
        Expr whereExpr = this._andExpr.getSingleExpr();
        this._andExpr = null;
        query.setWhereExpr(whereExpr);
        query.setParams(params);
        for (int i = resultItems.size() - 1; i >= 0; --i) {
            Expr subExpr = (Expr)resultItems.get(i);
            if (!(subExpr instanceof UnboundStarExpr)) continue;
            UnboundStarExpr unboundExpr = (UnboundStarExpr)subExpr;
            ArrayList<Expr> exprList = unboundExpr.expand(query.getFromItems());
            resultItems.remove(i);
            resultItems.addAll(i, exprList);
        }
        ArrayList<Expr> groupItems = null;
        token = this.scanToken();
        if (token == 144) {
            token = this.scanToken();
            if (token != 145) {
                throw this.error(L.l("expected BY at `{0}'", this.tokenName(token)));
            }
            groupItems = this.parseGroup(query);
        } else {
            this._token = token;
        }
        token = this.scanToken();
        if (token == 143) {
            token = this.scanToken();
            if (token != 145) {
                throw this.error(L.l("expected BY at `{0}'", this.tokenName(token)));
            }
            Order order = this.parseOrder(query, resultItems);
        } else {
            this._token = token;
        }
        Expr[] resultArray = resultItems.toArray(new Expr[resultItems.size()]);
        query.setResults(resultArray);
        if (query.isGroup()) {
            Expr[] resultList = query.getResults();
            this.bindGroup(query, groupItems);
            for (int i = 0; i < resultList.length; ++i) {
                Expr subExpr = resultList[i];
                if (subExpr instanceof GroupExpr) continue;
                resultList[i] = new GroupResultExpr(i, subExpr);
            }
        }
        this._token = token = this.scanToken();
        if (query.getParent() == null && token >= 0 && token != 148 && token != 149) {
            throw this.error(L.l("unexpected token at end '{0}'", this.tokenName(token)));
        }
        this._query = query.getParent();
        this._andExpr = oldAnd;
        return query;
    }

    private ArrayList<FromItem> parseFromItems() throws SQLException {
        int token;
        ArrayList<FromItem> fromItems = new ArrayList<FromItem>();
        while ((token = this.scanToken()) == 40) {
        }
        this._token = token;
        FromItem fromItem = this.parseFromItem();
        if (fromItem != null) {
            fromItems.add(fromItem);
        }
        while (true) {
            token = this.scanToken();
            boolean isNatural = false;
            boolean isOuter = false;
            boolean isLeft = true;
            boolean isRight = true;
            if (token == 44) {
                fromItem = this.parseFromItem();
                fromItems.add(fromItem);
                continue;
            }
            if (token == 40 || token == 41) continue;
            if (token != 128) {
                this._token = token;
                break;
            }
            if (!"join".equalsIgnoreCase(this._lexeme)) {
                String name;
                if ("inner".equalsIgnoreCase(this._lexeme)) {
                    String join = this.parseIdentifier();
                    if (!"join".equalsIgnoreCase(join)) {
                        throw this.error(L.l("expected JOIN at '{0}'", join));
                    }
                } else if ("left".equalsIgnoreCase(this._lexeme)) {
                    name = this.parseIdentifier();
                    if ("outer".equalsIgnoreCase(name)) {
                        name = this.parseIdentifier();
                    }
                    if (!"join".equalsIgnoreCase(name)) {
                        throw this.error(L.l("expected JOIN at '{0}'", name));
                    }
                    isOuter = true;
                } else {
                    if ("right".equalsIgnoreCase(this._lexeme)) {
                        name = this.parseIdentifier();
                        if ("outer".equalsIgnoreCase(name)) {
                            name = this.parseIdentifier();
                        }
                        if (!"join".equalsIgnoreCase(name)) {
                            throw this.error(L.l("expected JOIN at '{0}'", name));
                        }
                        isRight = true;
                        isOuter = true;
                        throw this.error(L.l("right outer joins are not supported"));
                    }
                    if (!"natural".equalsIgnoreCase(this._lexeme)) {
                        this._token = token;
                        break;
                    }
                    name = this.parseIdentifier();
                    isNatural = true;
                    if ("left".equalsIgnoreCase(name)) {
                        name = this.parseIdentifier();
                        if ("outer".equalsIgnoreCase(name)) {
                            name = this.parseIdentifier();
                        }
                        isOuter = true;
                    } else if ("right".equalsIgnoreCase(name)) {
                        name = this.parseIdentifier();
                        if ("outer".equalsIgnoreCase(name)) {
                            name = this.parseIdentifier();
                        }
                        isRight = true;
                        isOuter = true;
                        throw this.error(L.l("right outer joins are not supported"));
                    }
                    if (!"join".equalsIgnoreCase(name)) {
                        throw this.error(L.l("expected JOIN at '{0}'", name));
                    }
                }
            }
            fromItem = this.parseFromItem();
            fromItems.add(fromItem);
            this._query.setFromItems(fromItems);
            token = this.scanToken();
            if (token == 128 && "on".equalsIgnoreCase(this._lexeme)) {
                Expr onExpr = this.parseExpr();
                if (isOuter) {
                    FromItem leftItem = fromItems.get(fromItems.size() - 2);
                    FromItem rightItem = fromItems.get(fromItems.size() - 1);
                    onExpr = new LeftOuterJoinExpr(rightItem, onExpr);
                    rightItem.setDependTable(leftItem);
                }
                this._andExpr.add(onExpr);
                continue;
            }
            this._token = token;
        }
        return fromItems;
    }

    private Expr parseSelectExpr() throws SQLException {
        int token = this.scanToken();
        if (token == 42) {
            return new UnboundStarExpr();
        }
        this._token = token;
        return this.parseExpr();
    }

    private FromItem parseFromItem() throws SQLException {
        String tableName = this.parseIdentifier();
        if (tableName.equalsIgnoreCase("DUAL")) {
            return null;
        }
        Table table = this._database.getTable(tableName);
        if (table == null) {
            throw this.error(L.l("'{0}' is an unknown table.  'FROM table' requires an existing table.", tableName));
        }
        String name = table.getName();
        int token = this.scanToken();
        if (token == 142) {
            name = this.parseIdentifier();
        } else if (token == 128) {
            name = this._lexeme;
        } else {
            this._token = token;
        }
        return new FromItem(table, name);
    }

    private Order parseOrder(SelectQuery query, ArrayList<Expr> resultList) throws SQLException {
        int token;
        Order order = null;
        do {
            Expr resultExpr;
            int index;
            Expr expr = this.parseExpr();
            expr = expr.bind(query);
            token = this.scanToken();
            boolean isAsc = true;
            if (token == 146) {
                isAsc = true;
            } else if (token == 147) {
                isAsc = false;
            } else {
                this._token = token;
            }
            for (index = 0; index < resultList.size() && !expr.equals(resultExpr = resultList.get(index)); ++index) {
            }
            if (resultList.size() <= index) {
                resultList.add(expr);
            }
            Order tailOrder = expr.createOrder(index);
            tailOrder.setAscending(isAsc);
            order = Order.append(order, tailOrder);
        } while ((token = this.scanToken()) == 44);
        query.setOrder(order);
        this._token = token;
        return order;
    }

    private ArrayList<Expr> parseGroup(SelectQuery query) throws SQLException {
        int token;
        query.setGroup(true);
        ArrayList<Expr> groupList = new ArrayList<Expr>();
        do {
            groupList.add(this.parseExpr());
        } while ((token = this.scanToken()) == 44);
        this._token = token;
        return groupList;
    }

    private void bindGroup(SelectQuery query, ArrayList<Expr> groupList) throws SQLException {
        query.setGroup(true);
        Expr[] resultList = query.getResults();
        for (int i = 0; i < groupList.size(); ++i) {
            int index;
            Expr expr = groupList.get(i);
            expr = expr.bind(query);
            for (index = 0; index < resultList.length; ++index) {
                Expr resultExpr = resultList[index];
                if (!expr.equals(resultExpr)) continue;
                resultList[index] = new GroupResultExpr(index, resultExpr);
                break;
            }
            if (resultList.length <= index) {
                throw this.error(L.l("GROUP BY field '{0}' must refer to a result field.", expr));
            }
            query.setGroupResult(index);
        }
    }

    private Query parseCreate() throws SQLException {
        TableFactory factory = this._database.createTableFactory();
        int token = this.scanToken();
        if (token != 166) {
            throw this.error(L.l("expected TABLE at `{0}'", this.tokenName(token)));
        }
        token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        factory.startTable(this._lexeme);
        token = this.scanToken();
        if (token != 40) {
            throw this.error(L.l("expected '(' at `{0}'", this.tokenName(token)));
        }
        block7: do {
            token = this.scanToken();
            switch (token) {
                case 128: {
                    this.parseCreateColumn(factory, this._lexeme);
                    break;
                }
                case 175: {
                    factory.addUnique(this.parseColumnNames());
                    break;
                }
                case 176: {
                    token = this.scanToken();
                    if (token != 179) {
                        throw this.error(L.l("expected 'key' at {0}", this.tokenName(token)));
                    }
                    factory.addPrimaryKey(this.parseColumnNames());
                    break;
                }
                case 179: {
                    String key = this.parseIdentifier();
                    this.parseColumnNames();
                    break;
                }
                case 177: {
                    token = this.scanToken();
                    if (token != 40) {
                        throw this.error(L.l("Expected '(' at '{0}'", this.tokenName(token)));
                    }
                    this.parseExpr();
                    token = this.scanToken();
                    if (token == 41) continue block7;
                    throw this.error(L.l("Expected ')' at '{0}'", this.tokenName(token)));
                }
                default: {
                    throw this.error(L.l("unexpected token `{0}'", this.tokenName(token)));
                }
            }
        } while ((token = this.scanToken()) == 44);
        if (token != 41) {
            throw this.error(L.l("expected ')' at `{0}'", this.tokenName(token)));
        }
        return new CreateQuery(this._database, this._sql, factory);
    }

    private void parseCreateColumn(TableFactory factory, String name) throws SQLException {
        int token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected column type at {0}", this.tokenName(token)));
        }
        String type = this._lexeme;
        int length = -1;
        int scale = -1;
        if (type.equalsIgnoreCase("double")) {
            token = this.scanToken();
            if (token == 128) {
                if (!this._lexeme.equalsIgnoreCase("precision")) {
                    throw this.error(L.l("unexpected double type at {0}", this._lexeme));
                }
            } else {
                this._token = token;
            }
        }
        if ((token = this.scanToken()) == 40) {
            token = this.scanToken();
            if (token != 129) {
                throw this.error(L.l("expected column width at `{0}'", this.tokenName(token)));
            }
            length = Integer.parseInt(this._lexeme);
            token = this.scanToken();
            if (token == 44) {
                token = this.scanToken();
                if (token != 129) {
                    throw this.error(L.l("expected column scale at `{0}'", this.tokenName(token)));
                }
                scale = Integer.parseInt(this._lexeme);
                token = this.scanToken();
            }
            if (token != 41) {
                throw this.error(L.l("expected ')' at '{0}'", this.tokenName(token)));
            }
        } else {
            this._token = token;
        }
        if (type.equalsIgnoreCase("varchar")) {
            if (length < 0) {
                throw this.error(L.l("VARCHAR needs a defined length"));
            }
            factory.addVarchar(name, length);
        } else if (type.equalsIgnoreCase("char")) {
            if (length < 0) {
                length = 1;
            }
            factory.addVarchar(name, length);
        } else if (type.equalsIgnoreCase("blob")) {
            factory.addBlob(name);
        } else if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("int") || type.equalsIgnoreCase("smallint") || type.equalsIgnoreCase("tinyint") || type.equalsIgnoreCase("mediumint") || type.equalsIgnoreCase("bit")) {
            factory.addInteger(name);
        } else if (type.equalsIgnoreCase("bigint")) {
            factory.addLong(name);
        } else if (type.equalsIgnoreCase("double") || type.equalsIgnoreCase("float") || type.equalsIgnoreCase("real")) {
            factory.addDouble(name);
        } else if (type.equalsIgnoreCase("datetime") || type.equalsIgnoreCase("timestamp")) {
            factory.addDateTime(name);
        } else if (type.equalsIgnoreCase("text") || type.equalsIgnoreCase("clob")) {
            factory.addVarchar(name, 255);
        } else if (type.equalsIgnoreCase("decimal") || type.equalsIgnoreCase("numeric")) {
            factory.addNumeric(name, length, scale);
        } else {
            throw this.error(L.l("Unknown type {0}", type));
        }
        token = this.scanToken();
        if (token == 128 && this._lexeme.equalsIgnoreCase("default")) {
            Expr defaultExpr = this.parseExpr();
            factory.setDefault(name, defaultExpr);
        } else {
            this._token = token;
        }
        block9: while (true) {
            token = this.scanToken();
            switch (token) {
                case 41: 
                case 44: {
                    this._token = token;
                    return;
                }
                case 175: {
                    factory.setUnique(name);
                    break;
                }
                case 176: {
                    token = this.scanToken();
                    if (token != 179) {
                        throw this.error(L.l("expected key at {0}", this.tokenName(token)));
                    }
                    factory.setPrimaryKey(name);
                    break;
                }
                case 177: {
                    token = this.scanToken();
                    if (token != 40) {
                        throw this.error(L.l("Expected '(' at '{0}'", this.tokenName(token)));
                    }
                    this.parseExpr();
                    token = this.scanToken();
                    if (token == 41) continue block9;
                    throw this.error(L.l("Expected ')' at '{0}'", this.tokenName(token)));
                }
                case 128: {
                    String id = this._lexeme;
                    if (id.equalsIgnoreCase("references")) {
                        ArrayList<String> foreignKey = new ArrayList<String>();
                        foreignKey.add(name);
                        this.parseReferences(foreignKey);
                        break;
                    }
                    if (id.equalsIgnoreCase("default")) {
                        Expr expr = this.parseExpr();
                        break;
                    }
                    if (id.equalsIgnoreCase("auto_increment")) {
                        factory.setAutoIncrement(name, 1);
                        break;
                    }
                    if (id.equalsIgnoreCase("unsigned") || id.equalsIgnoreCase("binary")) continue block9;
                    throw this.error(L.l("unexpected token '{0}'", this.tokenName(token)));
                }
                case 136: {
                    break;
                }
                case 163: {
                    token = this.scanToken();
                    if (token == 136) {
                        factory.setNotNull(name);
                        break;
                    }
                    throw this.error(L.l("unexpected token '{0}'", this.tokenName(token)));
                }
                default: {
                    throw this.error(L.l("unexpected token '{0}'", this.tokenName(token)));
                }
            }
        }
    }

    private void parseKeyConstraint(TableFactory factory) throws SQLException {
        String key = this.parseIdentifier();
        int token = this.scanToken();
        if (token == 40) {
            this.parseIdentifier();
            token = this.scanToken();
            if (token != 41) {
                throw this.error("expected ')'");
            }
        } else {
            this._token = token;
        }
    }

    public void parseReferences(ArrayList<String> name) throws SQLException {
        String foreignTable = this.parseIdentifier();
        int token = this.scanToken();
        ArrayList<Object> foreignColumns = new ArrayList();
        if (token == 40) {
            this._token = token;
            foreignColumns = this.parseColumnNames();
        } else {
            this._token = token;
        }
    }

    public ArrayList<String> parseColumnNames() throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        int token = this.scanToken();
        if (token == 40) {
            do {
                columns.add(this.parseIdentifier());
            } while ((token = this.scanToken()) == 44);
            if (token != 41) {
                throw this.error(L.l("expected ')' at '{0}'", this.tokenName(token)));
            }
        } else if (token == 128) {
            columns.add(this._lexeme);
            this._token = token;
        } else {
            throw this.error(L.l("expected '(' at '{0}'", this.tokenName(token)));
        }
        return columns;
    }

    private Query parseInsert() throws SQLException {
        int token = this.scanToken();
        if (token != 168) {
            throw this.error(L.l("expected INTO at `{0}'", this.tokenName(token)));
        }
        token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        Table table = this._database.getTable(this._lexeme);
        if (table == null) {
            throw this.error(L.l("unknown table `{0}'", this.tokenName(token)));
        }
        FromItem fromItem = new FromItem(table, table.getName());
        FromItem[] fromList = new FromItem[]{fromItem};
        ArrayList<Column> columns = new ArrayList<Column>();
        token = this.scanToken();
        if (token == 40) {
            do {
                String columnName;
                Column column;
                if ((column = table.getColumn(columnName = this.parseIdentifier())) == null) {
                    throw new SQLException(L.l("`{0}' is not a valid column in {1}", (Object)columnName, table.getName()));
                }
                columns.add(column);
            } while ((token = this.scanToken()) == 44);
            if (token != 41) {
                throw this.error(L.l("expected ')' at `{0}'", this.tokenName(token)));
            }
            token = this.scanToken();
        } else {
            Column[] columnArray = table.getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                columns.add(columnArray[i]);
            }
        }
        if (token != 169) {
            throw this.error(L.l("expected VALUES at `{0}'", this.tokenName(token)));
        }
        token = this.scanToken();
        if (token != 40) {
            throw this.error(L.l("expected '(' at `{0}'", this.tokenName(token)));
        }
        ArrayList<Expr> values = new ArrayList<Expr>();
        InsertQuery query = new InsertQuery(this._database, this._sql, table, columns);
        this._query = query;
        int i = 0;
        do {
            Expr expr = this.parseExpr();
            expr = expr.bind(new TempQuery(fromList));
            values.add(expr);
            ++i;
        } while ((token = this.scanToken()) == 44);
        if (token != 41) {
            throw this.error(L.l("expected ')' at {0}", this.tokenName(token)));
        }
        if (columns.size() != values.size()) {
            throw this.error(L.l("number of columns does not match number of values"));
        }
        ParamExpr[] params = this._params.toArray(new ParamExpr[this._params.size()]);
        query.setParams(params);
        query.setValues(values);
        query.init();
        return query;
    }

    private Query parseDelete() throws SQLException {
        int token = this.scanToken();
        if (token != 138) {
            throw this.error(L.l("expected FROM at `{0}'", this.tokenName(token)));
        }
        token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        Table table = this._database.getTable(this._lexeme);
        if (table == null) {
            throw this.error(L.l("unknown table `{0}'", this.tokenName(token)));
        }
        DeleteQuery query = new DeleteQuery(this._database, this._sql, table);
        this._query = query;
        Expr whereExpr = null;
        token = this.scanToken();
        if (token == 141) {
            whereExpr = this.parseExpr();
        } else if (token >= 0) {
            throw this.error(L.l("expected WHERE at `{0}'", this.tokenName(token)));
        }
        ParamExpr[] params = this._params.toArray(new ParamExpr[this._params.size()]);
        query.setParams(params);
        query.setWhereExpr(whereExpr);
        return query;
    }

    private Query parseDrop() throws SQLException {
        int token = this.scanToken();
        if (token != 166) {
            throw this.error(L.l("expected TABLE at `{0}'", this.tokenName(token)));
        }
        token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        String table = this._lexeme;
        token = this.scanToken();
        if (token >= 0) {
            throw this.error(L.l("expected end of query at `{0}'", this.tokenName(token)));
        }
        return new DropQuery(this._sql, this._database, table);
    }

    private Query parseUpdate() throws SQLException {
        int token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        String name = this._lexeme;
        Table table = this._database.getTable(name);
        if (table == null) {
            throw this.error(L.l("`{0}' is an unknown table in INSERT.", name));
        }
        token = this.scanToken();
        if (token != 172) {
            throw this.error(L.l("expected SET at {0}", this.tokenName(token)));
        }
        UpdateQuery query = new UpdateQuery(this._database, this._sql, table);
        this._query = query;
        ArrayList<SetItem> setItemList = new ArrayList<SetItem>();
        do {
            SetItem item = this.parseSetItem(table);
            setItemList.add(item);
        } while ((token = this.scanToken()) == 44);
        Expr whereExpr = null;
        if (token == 141) {
            whereExpr = this.parseExpr();
        }
        SetItem[] setItems = new SetItem[setItemList.size()];
        setItemList.toArray(setItems);
        ParamExpr[] params = this._params.toArray(new ParamExpr[this._params.size()]);
        query.setSetItems(setItems);
        query.setParams(params);
        query.setWhereExpr(whereExpr);
        return query;
    }

    private SetItem parseSetItem(Table table) throws SQLException {
        int token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        Column column = table.getColumn(this._lexeme);
        if (column == null) {
            throw this.error(L.l("`{0}' is an unknown column in table {1}.", (Object)this._lexeme, table.getName()));
        }
        token = this.scanToken();
        if (token != 155) {
            throw this.error(L.l("expected `=' at {0}", this.tokenName(token)));
        }
        Expr expr = this.parseExpr();
        return new SetItem(table, column, expr);
    }

    private Expr parseExpr() throws SQLException {
        int token = this.scanToken();
        if (token == 140) {
            return this.parseSubSelect();
        }
        this._token = token;
        return this.parseOrExpr();
    }

    private Expr parseSubSelect() throws SQLException {
        return this.parseSubSelect(new SelectQuery(this._database, this._sql));
    }

    private Expr parseSubSelect(SelectQuery query) throws SQLException {
        this.parseSelect(query);
        SubSelectExpr expr = new SubSelectExpr(query);
        query.setSubSelect(expr);
        this._andExpr.add(new SubSelectEvalExpr(expr));
        return expr;
    }

    private Expr parseOrExpr() throws SQLException {
        int token;
        Expr left = this.parseAndExpr();
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 162: {
                    left = new OrExpr(left, this.parseAndExpr());
                    continue block3;
                }
            }
            break;
        }
        this._token = token;
        return left;
    }

    private Expr parseAndExpr() throws SQLException {
        int token;
        AndExpr andExpr;
        AndExpr oldAndExpr = this._andExpr;
        this._andExpr = andExpr = new AndExpr();
        andExpr.add(this.parseNotExpr());
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 161: {
                    andExpr.add(this.parseNotExpr());
                    continue block3;
                }
            }
            break;
        }
        this._token = token;
        this._andExpr = oldAndExpr;
        return andExpr.getSingleExpr();
    }

    private Expr parseNotExpr() throws SQLException {
        int token = this.scanToken();
        switch (token) {
            case 163: {
                return new NotExpr(this.parseNotExpr());
            }
        }
        this._token = token;
        return this.parseCmpExpr();
    }

    private Expr parseCmpExpr() throws SQLException {
        Expr left = this.parseConcatExpr();
        int token = this.scanToken();
        boolean isNot = false;
        if (token == 163) {
            isNot = true;
            token = this.scanToken();
            if (token != 150 && token != 151 && token != 139) {
                this._token = token;
                return left;
            }
        }
        switch (token) {
            case 155: {
                return new EqExpr(left, this.parseConcatExpr());
            }
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                return new CmpExpr(left, this.parseConcatExpr(), token);
            }
            case 150: {
                Expr min = this.parseConcatExpr();
                token = this.scanToken();
                if (token != 161) {
                    throw this.error(L.l("expected AND at '{0}'", this.tokenName(token)));
                }
                Expr max = this.parseConcatExpr();
                return new BetweenExpr(left, min, max, isNot);
            }
            case 153: {
                token = this.scanToken();
                isNot = false;
                if (token == 163) {
                    token = this.scanToken();
                    isNot = true;
                }
                if (token == 136) {
                    return new IsNullExpr(left, isNot);
                }
                throw this.error(L.l("expected NULL at '{0}'", this.tokenName(token)));
            }
            case 151: {
                token = this.scanToken();
                if (token == 132) {
                    return new LikeExpr(left, this._lexeme, isNot);
                }
                throw this.error(L.l("expected string at '{0}'", this.tokenName(token)));
            }
            case 139: {
                HashSet<String> values = this.parseInValues();
                return new InExpr(left, values, isNot);
            }
        }
        this._token = token;
        return left;
    }

    private HashSet<String> parseInValues() throws SQLException {
        int token = this.scanToken();
        if (token != 40) {
            throw this.error(L.l("Expected '('"));
        }
        HashSet<String> values = new HashSet<String>();
        while ((token = this.scanToken()) != 41) {
            if (token != 132) {
                throw this.error(L.l("expected STRING at {0}", this.tokenName(token)));
            }
            values.add(this._lexeme);
            token = this.scanToken();
            if (token == 44) continue;
        }
        if (token != 41) {
            throw this.error(L.l("expected ')' at {0}", this.tokenName(token)));
        }
        return values;
    }

    private Expr parseConcatExpr() throws SQLException {
        int token;
        Expr left = this.parseAddExpr();
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 154: {
                    left = new ConcatExpr(left, this.parseAddExpr());
                    continue block3;
                }
            }
            break;
        }
        this._token = token;
        return left;
    }

    private Expr parseAddExpr() throws SQLException {
        int token;
        Expr left = this.parseMulExpr();
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 43: 
                case 45: {
                    left = new BinaryExpr(left, this.parseMulExpr(), token);
                    continue block3;
                }
            }
            break;
        }
        this._token = token;
        return left;
    }

    private Expr parseMulExpr() throws SQLException {
        int token;
        Expr left = this.parseTerm();
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 37: 
                case 42: 
                case 47: {
                    left = new BinaryExpr(left, this.parseTerm(), token);
                    continue block3;
                }
            }
            break;
        }
        this._token = token;
        return left;
    }

    private Expr parseTerm() throws SQLException {
        int token = this.scanToken();
        switch (token) {
            case 43: {
                return this.parseTerm();
            }
            case 45: {
                return new UnaryExpr(this.parseTerm(), token);
            }
            case 40: {
                Expr expr = this.parseExpr();
                int peekToken = this.scanToken();
                if (peekToken != 41) {
                    throw this.error(L.l("expected ')' at {0}", this.tokenName(peekToken)));
                }
                return expr;
            }
        }
        this._token = token;
        return this.parseSimpleTerm();
    }

    private Expr parseSimpleTerm() throws SQLException {
        int token = this.scanToken();
        switch (token) {
            case 128: {
                String name = this._lexeme;
                token = this.scanToken();
                if (token == 46) {
                    token = this.scanToken();
                    if (token == 128) {
                        String column = this._lexeme;
                        return this._query.bind(name, column);
                    }
                    if (token == 42) {
                        return new UnboundStarExpr(name);
                    }
                    throw this.error("expected IDENTIFIER");
                }
                if (token == 40) {
                    FunExpr fun = null;
                    if (name.equalsIgnoreCase("max")) {
                        fun = new MaxExpr();
                    } else if (name.equalsIgnoreCase("min")) {
                        fun = new MinExpr();
                    } else if (name.equalsIgnoreCase("sum")) {
                        fun = new SumExpr();
                    } else if (name.equalsIgnoreCase("avg")) {
                        fun = new AvgExpr();
                    } else if (name.equalsIgnoreCase("count")) {
                        fun = new CountExpr();
                        token = this.scanToken();
                        if (token == 42) {
                            fun.addArg(new UnboundStarExpr());
                        } else {
                            this._token = token;
                        }
                    } else {
                        if (name.equalsIgnoreCase("exists")) {
                            token = this.scanToken();
                            if (token != 140) {
                                throw this.error(L.l("exists requires SELECT at '{0}'", this.tokenName(token)));
                            }
                            ExistsQuery query = new ExistsQuery(this._database, this._sql);
                            this.parseSelect(query);
                            ExistsExpr expr = new ExistsExpr(query);
                            query.setSubSelect(expr);
                            this._andExpr.add(new ExistsEvalExpr(expr));
                            token = this.scanToken();
                            if (token != 41) {
                                throw this.error(L.l("exists requires ')' at '{0}'", this.tokenName(token)));
                            }
                            return expr;
                        }
                        String funName = new CharBuffer().append(Character.toUpperCase(name.charAt(0))).append(name.substring(1).toLowerCase()).toString();
                        funName = new CharBuffer().append("com.caucho.db.fun.").append(funName).append("Expr").toString();
                        try {
                            Class<?> cl = Class.forName(funName);
                            fun = (FunExpr)cl.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            log.finer(e.toString());
                        }
                        catch (Throwable e) {
                            log.log(Level.FINER, e.toString(), e);
                        }
                        if (fun == null) {
                            throw this.error(L.l("`{0}' is an unknown function.", name));
                        }
                    }
                    token = this.scanToken();
                    while (token > 0 && token != 41) {
                        this._token = token;
                        Expr arg = this.parseExpr();
                        fun.addArg(arg);
                        token = this.scanToken();
                        if (token != 44) continue;
                        token = this.scanToken();
                    }
                    return fun;
                }
                this._token = token;
                return this._query.bind(null, name);
            }
            case 132: {
                return new StringExpr(this._lexeme);
            }
            case 129: 
            case 130: 
            case 131: {
                return NumberExpr.create(this._lexeme);
            }
            case 136: {
                return new NullExpr();
            }
            case 133: {
                return BooleanLiteralExpr.create(true);
            }
            case 134: {
                return BooleanLiteralExpr.create(false);
            }
            case 63: {
                ParamExpr param = new ParamExpr(this._params.size());
                this._params.add(param);
                return param;
            }
        }
        throw this.error(L.l("unexpected term {0}", this.tokenName(token)));
    }

    private String parseIdentifier() throws SQLException {
        int token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at {0}", this.tokenName(token)));
        }
        return this._lexeme;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanToken() throws SQLException {
        CharBuffer cb;
        if (this._token > 0) {
            int value = this._token;
            this._token = -1;
            return value;
        }
        int sign = 1;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        switch (ch) {
            case -1: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 63: {
                return ch;
            }
            case 43: {
                ch = this.read();
                if (ch >= 48 && ch <= 57) break;
                this.unread(ch);
                return 43;
            }
            case 45: {
                ch = this.read();
                if (ch >= 48 && ch <= 57) {
                    sign = -1;
                    break;
                }
                this.unread(ch);
                return 45;
            }
            case 61: {
                return 155;
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 158;
                }
                if (ch == 62) {
                    return 156;
                }
                this.unread(ch);
                return 157;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 160;
                }
                this.unread(ch);
                return 159;
            }
            case 124: {
                ch = this.read();
                if (ch == 124) {
                    return 154;
                }
                throw this.error(L.l("'|' expected at {0}", this.charName(ch)));
            }
            case 64: {
                ch = this.read();
                if (ch != 64) {
                    throw this.error(L.l("`@' expected at {0}", this.charName(ch)));
                }
                return this.scanToken();
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            CharBuffer cb2 = this._cb;
            cb2.clear();
            while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                cb2.append((char)ch);
                ch = this.read();
            }
            this.unread(ch);
            this._lexeme = cb2.toString();
            String lower = this._lexeme.toLowerCase();
            int token = _reserved.get(lower);
            if (token > 0) {
                return token;
            }
            return 128;
        }
        if (ch >= 48 && ch <= 57) {
            CharBuffer cb3 = this._cb;
            cb3.clear();
            int type = 129;
            if (sign < 0) {
                cb3.append('-');
            }
            while (ch >= 48 && ch <= 57) {
                cb3.append((char)ch);
                ch = this.read();
            }
            if (ch == 46) {
                type = 131;
                cb3.append('.');
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb3.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 101 || ch == 69) {
                type = 131;
                cb3.append('e');
                ch = this.read();
                if (ch == 43 || ch == 45) {
                    cb3.append((char)ch);
                    ch = this.read();
                }
                if (ch < 48 || ch > 57) {
                    throw this.error(L.l("exponent needs digits at {0}", this.charName(ch)));
                }
                while (ch >= 48 && ch <= 57) {
                    cb3.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 70 || ch == 68) {
                type = 131;
            } else if (ch == 76) {
                type = 130;
            } else {
                this.unread(ch);
            }
            this._lexeme = cb3.toString();
            return type;
        }
        if (ch == 39) {
            cb = this._cb;
            cb.clear();
            ch = this.read();
        } else {
            if (ch != 35) {
                throw this.error(L.l("unexpected char at {0} ({1})", (Object)new CharBuffer().append("").append((char)ch).toString(), String.valueOf(ch)));
            }
            while ((ch = this.read()) >= 0 && ch != 10 && ch != 13) {
            }
            return this.scanToken();
        }
        while (ch >= 0) {
            block45: {
                if (ch == 39) {
                    ch = this.read();
                    if (ch == 39) {
                        cb.append('\'');
                        break block45;
                    } else {
                        this.unread(ch);
                        break;
                    }
                }
                if (ch == 92) {
                    ch = this.read();
                    if (ch >= 0) {
                        cb.append(ch);
                    }
                } else {
                    cb.append((char)ch);
                }
            }
            ch = this.read();
        }
        this._lexeme = cb.toString();
        return 132;
    }

    private int read() {
        if (this._parseIndex < this._sqlLength) {
            return this._sqlChars[this._parseIndex++];
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._parseIndex;
        }
    }

    private String charName(int ch) {
        if (ch < 0) {
            return L.l("end of query");
        }
        return String.valueOf((char)ch);
    }

    private String tokenName(int token) {
        switch (token) {
            case 142: {
                return "AS";
            }
            case 164: {
                return "?";
            }
            case 138: {
                return "FROM";
            }
            case 139: {
                return "IN";
            }
            case 140: {
                return "SELECT";
            }
            case 141: {
                return "WHERE";
            }
            case 162: {
                return "OR";
            }
            case 161: {
                return "AND";
            }
            case 163: {
                return "NOT";
            }
            case 150: {
                return "BETWEEN";
            }
            case 133: {
                return "TRUE";
            }
            case 134: {
                return "FALSE";
            }
            case 136: {
                return "NULL";
            }
            case 144: {
                return "GROUP";
            }
            case 143: {
                return "ORDER";
            }
            case 145: {
                return "BY";
            }
            case 146: {
                return "ASC";
            }
            case 147: {
                return "DESC";
            }
            case 148: {
                return "LIMIT";
            }
            case -1: {
                return L.l("end of query");
            }
        }
        if (token < 128) {
            return new CharBuffer().append("'").append(String.valueOf((char)token)).append("'").toString();
        }
        return new CharBuffer().append("'").append(this._lexeme).append("'").toString();
    }

    private SQLException error(String msg) {
        return new SQLParseException(new CharBuffer().append(msg).append("\n").append(this._sql).toString());
    }

    static {
        _reserved.put("as", 142);
        _reserved.put("from", 138);
        _reserved.put("in", 139);
        _reserved.put("select", 140);
        _reserved.put("distinct", 141);
        _reserved.put("where", 141);
        _reserved.put("order", 143);
        _reserved.put("group", 144);
        _reserved.put("by", 145);
        _reserved.put("asc", 146);
        _reserved.put("desc", 147);
        _reserved.put("limit", 148);
        _reserved.put("offset", 149);
        _reserved.put("or", 162);
        _reserved.put("and", 161);
        _reserved.put("not", 163);
        _reserved.put("between", 150);
        _reserved.put("like", 151);
        _reserved.put("escape", 152);
        _reserved.put("is", 153);
        _reserved.put("true", 133);
        _reserved.put("false", 134);
        _reserved.put("unknown", 135);
        _reserved.put("null", 136);
        _reserved.put("create", 165);
        _reserved.put("table", 166);
        _reserved.put("insert", 167);
        _reserved.put("into", 168);
        _reserved.put("values", 169);
        _reserved.put("drop", 170);
        _reserved.put("update", 171);
        _reserved.put("set", 172);
        _reserved.put("delete", 173);
        _reserved.put("constraint", 174);
        _reserved.put("unique", 175);
        _reserved.put("check", 177);
        _reserved.put("primary", 176);
        _reserved.put("key", 179);
        _reserved.put("foreign", 178);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.Parser");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

