/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.SelectResult;
import com.caucho.log.Log;
import com.caucho.util.IntArray;
import java.sql.SQLException;
import java.util.logging.Logger;

abstract class Order {
    private static final Logger log = Log.open(Order._resin_compat_class_0());
    private boolean _isAscending = true;
    protected Order _next;
    private static Class _resin_compat_class_0;

    Order() {
    }

    public boolean isAscending() {
        return this._isAscending;
    }

    public void setAscending(boolean isAscending) {
        this._isAscending = isAscending;
    }

    static Order append(Order order, Order next) {
        if (order == null) {
            return next;
        }
        order._next = next;
        return order;
    }

    public abstract int compare(SelectResult var1, int var2, int var3) throws SQLException;

    public void sort(SelectResult result, IntArray rowArray) throws SQLException {
        int[] rows = rowArray.getArray();
        int size = rowArray.size();
        this.sort(result, rows, 0, size);
    }

    private void sort(SelectResult result, int[] rows, int offset, int length) throws SQLException {
        if (length > 3) {
            int head = offset;
            int tail = offset + length - 1;
            int pivot = offset + length / 2;
            int pivotIndex = rows[pivot];
            while (head <= tail) {
                int headIndex = rows[head];
                if (this.compare(result, headIndex, pivotIndex) < 0) {
                    ++head;
                    continue;
                }
                int temp = rows[tail];
                rows[tail] = headIndex;
                rows[head] = temp;
                --tail;
            }
            if (head == offset) {
                this.sort(result, rows, offset + 1, length - 1);
            } else if (head + 1 < offset + length) {
                this.sort(result, rows, offset, head - offset);
                this.sort(result, rows, head, offset + length - head);
            } else {
                this.sort(result, rows, offset, length - 1);
            }
        } else if (length == 3) {
            int temp;
            int indexA = rows[offset + 0];
            int indexB = rows[offset + 1];
            int indexC = rows[offset + 2];
            if (this.compare(result, indexB, indexA) < 0) {
                temp = indexA;
                indexA = indexB;
                indexB = temp;
            }
            if (this.compare(result, indexB, indexC) > 0) {
                if (this.compare(result, indexC, indexA) < 0) {
                    temp = indexC;
                    indexC = indexB;
                    indexB = indexA;
                    indexA = temp;
                } else {
                    temp = indexC;
                    indexC = indexB;
                    indexB = temp;
                }
            }
            rows[offset + 0] = indexA;
            rows[offset + 1] = indexB;
            rows[offset + 2] = indexC;
        } else if (length == 2) {
            int indexB = rows[offset + 1];
            int indexA = rows[offset];
            if (this.compare(result, indexB, indexA) < 0) {
                int temp = indexB;
                indexB = indexA;
                indexA = temp;
            }
            rows[offset + 0] = indexA;
            rows[offset + 1] = indexB;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.Order");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

