/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotExpr
extends Expr {
    private static final Logger log = Log.open(NotExpr._resin_compat_class_0());
    private Expr _sub;
    private static Class _resin_compat_class_0;

    NotExpr(Expr sub) {
        this._sub = sub;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        this._sub = this._sub.bind(query);
        if (!this._sub.isBoolean()) {
            throw new SQLException(L.l("NOT requires a boolean expression"));
        }
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._sub.subCost(fromList);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._sub.isNull(context);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        int value = this._sub.evalBoolean(context);
        switch (value) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        int value = this._sub.evalBoolean(context);
        switch (value) {
            case 1: {
                return "1";
            }
            case 0: {
                return "0";
            }
        }
        return null;
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._sub.evalGroup(context);
    }

    public String toString() {
        return new CharBuffer().append("NOT ").append(this._sub).toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.NotExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

