/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeftOuterJoinExpr
extends RowIterateExpr {
    private static final Logger log = Log.open(LeftOuterJoinExpr._resin_compat_class_0());
    private Expr _expr;
    private FromItem _table;
    private int _tableIndex;
    private static Class _resin_compat_class_0;

    LeftOuterJoinExpr(FromItem table, Expr expr) {
        this._table = table;
        this._expr = expr;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        if (!fromList.contains(this._table)) {
            return Integer.MAX_VALUE;
        }
        if (fromList.get(fromList.size() - 1) == this._table) {
            return 0L;
        }
        return 10000L;
    }

    @Override
    public RowIterateExpr getIndexExpr(FromItem fromItem) {
        if (this._table == fromItem) {
            return this;
        }
        return null;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        FromItem[] fromItems = query.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (this._table != fromItems[i]) continue;
            this._tableIndex = i;
        }
        return this;
    }

    @Override
    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return rowIter.next();
    }

    @Override
    boolean initRow(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        if (!rowIter.next()) {
            return false;
        }
        rowIter.initRow();
        Expr expr = this._expr;
        do {
            if (rowIter.nextRow()) continue;
            if (rowIter.next()) {
                rowIter.initRow();
                continue;
            }
            rowIter.initNullRow();
            return true;
        } while (expr.evalBoolean(context) != 1);
        TableIterator parentIter = context.getTableIterators()[1];
        return true;
    }

    @Override
    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return false;
    }

    @Override
    boolean nextRow(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        if (rowIter.isNullRow()) {
            return false;
        }
        Expr expr = this._expr;
        while (rowIter.nextRow() || rowIter.next()) {
            if (expr.evalBoolean(context) != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException {
        return false;
    }

    public String toString() {
        return new CharBuffer().append("LeftOuterJoinExpr(").append(this._expr).append(")").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.LeftOuterJoinExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

