/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcatExpr
extends Expr {
    private static final Logger log = Log.open(ConcatExpr._resin_compat_class_1());
    private Expr _left;
    private Expr _right;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    ConcatExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        this._left = this._left.bind(query);
        this._right = this._right.bind(query);
        return this;
    }

    @Override
    public Class getType() {
        return ConcatExpr._resin_compat_class_0();
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        String leftValue = this._left.evalString(context);
        String rightValue = this._right.evalString(context);
        if (leftValue == null) {
            return rightValue;
        }
        if (rightValue == null) {
            return leftValue;
        }
        return new CharBuffer().append(leftValue).append(rightValue).toString();
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        return new CharBuffer().append("(").append(this._left).append(" || ").append(this._right).append(")").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.db.sql.ConcatExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

