/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.logging.Logger;

class ColumnExpr
extends Expr {
    private static final Logger log = Log.open(ColumnExpr._resin_compat_class_0());
    private Table _table;
    private int _tableIndex;
    private Column _column;
    private int _columnIndex;
    private String _name;
    private Class _type;
    private static Class _resin_compat_class_0;

    ColumnExpr(String name, Table table, int tableIndex, int columnIndex, Class type) {
        this._name = name;
        this._table = table;
        this._tableIndex = tableIndex;
        this._columnIndex = columnIndex;
        this._column = table.getColumns()[this._columnIndex];
        this._type = type;
    }

    public Class getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public Column getColumn() {
        return this._column;
    }

    public Table getTable() {
        return this._table;
    }

    public boolean isNull(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isNull(this._column);
    }

    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getString(this._column);
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getInteger(this._column);
    }

    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getLong(this._column);
    }

    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getDouble(this._column);
    }

    public void evalToResult(QueryContext context, SelectResult result) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        row.evalToResult(this._column, result);
    }

    public boolean evalEqual(QueryContext context, byte[] matchBuffer) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isEqual(this._column, matchBuffer);
    }

    public boolean evalEqual(QueryContext context, String string) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isEqual(this._column, string);
    }

    public boolean equals(Object o) {
        if (o == null || !ColumnExpr._resin_compat_class_0().equals(o.getClass())) {
            return false;
        }
        ColumnExpr expr = (ColumnExpr)o;
        return this._tableIndex == expr._tableIndex && this._column == expr._column;
    }

    public String toString() {
        return new CharBuffer().append("ColumnExpr[").append(this._tableIndex).append(",").append(this._columnIndex).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.ColumnExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

