/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndExpr
extends Expr {
    private static final Logger log = Log.open(AndExpr._resin_compat_class_0());
    private ArrayList<Expr> _exprs = new ArrayList();
    private static Class _resin_compat_class_0;

    AndExpr() {
    }

    void add(Expr expr) {
        this._exprs.add(expr);
    }

    Expr getSingleExpr() {
        if (this._exprs.size() == 0) {
            return null;
        }
        if (this._exprs.size() == 1) {
            return this._exprs.get(0);
        }
        return this;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        for (int i = 0; i < this._exprs.size(); ++i) {
            Expr expr = this._exprs.get(i);
            if (!(expr = expr.bind(query)).getType().equals(Boolean.TYPE)) {
                throw new SQLException(L.l("AND requires boolean operands at {0}", expr));
            }
            this._exprs.set(i, expr);
        }
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        long cost = 0L;
        for (int i = 0; i < this._exprs.size(); ++i) {
            cost += this._exprs.get(i).subCost(fromList);
        }
        return cost;
    }

    @Override
    public void splitAnd(ArrayList<Expr> andProduct) {
        for (int i = 0; i < this._exprs.size(); ++i) {
            this._exprs.get(i).splitAnd(andProduct);
        }
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        boolean isNull = false;
        for (int i = 0; i < this._exprs.size(); ++i) {
            int value = this._exprs.get(i).evalBoolean(context);
            if (value == 0) {
                return false;
            }
            if (value == 1) continue;
            isNull = true;
        }
        return isNull;
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        int value = 1;
        for (int i = 0; i < this._exprs.size(); ++i) {
            int subValue = this._exprs.get(i).evalBoolean(context);
            if (subValue == 0) {
                return 0;
            }
            if (subValue != -1) continue;
            value = -1;
        }
        return value;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        switch (this.evalBoolean(context)) {
            case 1: {
                return "1";
            }
            case 0: {
                return "0";
            }
        }
        return null;
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("(");
        for (int i = 0; i < this._exprs.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(this._exprs.get(i));
        }
        cb.append(")");
        return cb.close();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.AndExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

