/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.debug;

import com.caucho.db.store.Store;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Logger;

public class DebugStore {
    private static final Logger log = Log.open(DebugStore._resin_compat_class_0());
    private static final L10N L = new L10N(DebugStore._resin_compat_class_0());
    Path _path;
    Store _store;
    private static Class _resin_compat_class_0;

    public DebugStore(Path path) throws Exception {
        this._path = path;
        this._store = Store.create(path);
        this._store.init();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: DebugStore store.db");
            return;
        }
        Path path = Vfs.lookup(args[0]);
        WriteStream out = Vfs.openWrite(System.out);
        new DebugStore(path).test(out);
        out.close();
    }

    public void test(WriteStream out) throws Exception {
        out.println(new CharBuffer().append("file-size   : ").append(this._store.getFileSize()).toString());
        out.println(new CharBuffer().append("block-count : ").append(this._store.getBlockCount()).toString());
        this.debugAllocation(out, this._store.getAllocationTable(), this._store.getBlockCount());
        this.debugFragments(out, this._store.getAllocationTable(), this._store.getBlockCount());
    }

    private void debugAllocation(WriteStream out, byte[] allocTable, long count) throws IOException {
        out.println();
        int i = 0;
        while ((long)i < count) {
            byte v = allocTable[i / 4];
            int code = v >> 2 * (i % 4) & 3;
            switch (code) {
                case 0: {
                    out.print('.');
                    break;
                }
                case 1: {
                    out.print('r');
                    break;
                }
                case 2: {
                    out.print('u');
                    break;
                }
                case 3: {
                    out.print('f');
                    break;
                }
                case 4: {
                    out.print('i');
                    break;
                }
                default: {
                    out.print('?');
                }
            }
            if (i % 64 == 63) {
                out.println();
            } else if (i % 8 == 7) {
                out.print(' ');
            }
            ++i;
        }
        out.println();
    }

    private void debugFragments(WriteStream out, byte[] allocTable, long count) throws Exception {
        long totalUsed = 0L;
        byte[] block = new byte[65536];
        int i = 0;
        while ((long)i < count) {
            byte v = allocTable[i / 4];
            int code = v >> 2 * (i % 4) & 3;
            if (code == 3) {
                this.readBlock(block, i);
                totalUsed += (long)this.debugFragmentBlock(out, block, i);
            }
            ++i;
        }
        out.println();
        out.println(new CharBuffer().append("Total-used: ").append(totalUsed).toString());
    }

    private int debugFragmentBlock(WriteStream out, byte[] block, long count) throws IOException {
        int used = this.readShort(block, 0);
        int fragCount = this.readShort(block, 2);
        out.println();
        out.println(new CharBuffer().append("Fragment Block ").append(count).append(": ").append(used).append("/").append(fragCount).toString());
        int offset = 4;
        int i = 0;
        while (offset < used) {
            if ((i & 7) == 0) {
                if (i != 0) {
                    out.println();
                }
                out.print(new CharBuffer().append(this.readShort(block, offset)).append(":").toString());
                offset += 2;
            }
            int len = this.readShort(block, offset);
            out.print(new CharBuffer().append(len).append(" ").toString());
            offset += 2 + len;
            ++i;
        }
        out.println();
        return used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBlock(byte[] block, long count) throws Exception {
        ReadStream is = this._path.openRead();
        try {
            is.skip(count * 65536L);
            is.read(block, 0, block.length);
        }
        finally {
            is.close();
        }
    }

    private int readShort(byte[] block, int offset) {
        return ((block[offset] & 0xFF) << 8) + (block[offset + 1] & 0xFF);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.debug.DebugStore");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

