/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.Config;
import com.caucho.config.NodeBuilder;
import com.caucho.config.TypeStrategy;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.w3c.dom.Node;

public class PathTypeStrategy
extends TypeStrategy {
    protected static final L10N L = new L10N(PathTypeStrategy._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
        String userPath = builder.configureRawString(node);
        return PathTypeStrategy.lookupPath(userPath);
    }

    public static Path lookupPath(String string) throws ELException {
        return PathTypeStrategy.lookupPath(string, Config.getEnvironment(), Vfs.lookup());
    }

    public static Path lookupPath(String string, VariableResolver env) throws ELException {
        return PathTypeStrategy.lookupPath(string, env, Vfs.lookup());
    }

    public static Path lookupPath(String string, VariableResolver env, Path pwd) throws ELException {
        Expr expr;
        Object obj;
        if (env == null) {
            env = Config.getEnvironment();
        }
        if ((obj = (expr = new ELParser(string = PathTypeStrategy.rewritePathString(string)).parse()).evalObject(env)) == null) {
            throw new NullPointerException(L.l("Path '{0}' evaluated to null.", string));
        }
        if (obj instanceof Path) {
            return (Path)obj;
        }
        String value = Expr.toString(obj, env);
        if (pwd != null) {
            return pwd.lookup(value);
        }
        return Vfs.lookup(value);
    }

    public static String rewritePathString(String pathName) {
        if (pathName == null) {
            return ".";
        }
        CharBuffer cb = new CharBuffer();
        int length = pathName.length();
        for (int i = 0; i < length; ++i) {
            char ch = pathName.charAt(i);
            if (ch != '$') {
                cb.append(ch);
                continue;
            }
            if (i + 1 == length) {
                cb.append('$');
                continue;
            }
            ch = pathName.charAt(i + 1);
            if ('0' <= ch && ch <= '9') {
                int value = 0;
                ++i;
                while (i < length && (ch = pathName.charAt(i)) >= '0' && ch <= '9') {
                    value = 10 * value + ch - 48;
                    ++i;
                }
                --i;
                cb.append(new CharBuffer().append("${regexp[").append(value).append("]}").toString());
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') {
                int tail;
                for (tail = i + 1; tail < length && (ch = pathName.charAt(tail)) != '/' && ch != '\\' && ch != '$'; ++tail) {
                }
                cb.append(new CharBuffer().append("${Var[\"").append(pathName.substring(i + 1, tail)).append("\"]}").toString());
                i = tail - 1;
                continue;
            }
            cb.append('$');
        }
        return cb.toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.types.PathTypeStrategy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

