/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeStrategy;
import com.caucho.config.ConfigException;
import com.caucho.config.NodeBuilder;
import com.caucho.config.TypeStrategy;
import com.caucho.config.TypeStrategyFactory;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class SetterAttributeStrategy
extends AttributeStrategy {
    private static final Logger log = Log.open(SetterAttributeStrategy._resin_compat_class_0());
    private static final L10N L = new L10N(SetterAttributeStrategy._resin_compat_class_0());
    private final Method _setter;
    private final TypeStrategy _typeStrategy;
    private static Class _resin_compat_class_0;

    public SetterAttributeStrategy(Method setter) throws Exception {
        if (!Modifier.isPublic(setter.getModifiers())) {
            throw new IllegalStateException(L.l("'{0}' is not public.", setter.toString()));
        }
        Class<?>[] param = setter.getParameterTypes();
        this._setter = setter;
        this._typeStrategy = TypeStrategyFactory.getTypeStrategy(param[0]);
    }

    public void configure(NodeBuilder builder, Object bean, QName name, Node node) throws Exception {
        Object value = this._typeStrategy.configure(builder, node, bean);
        this.setAttribute(bean, name, value);
    }

    public void setAttribute(Object bean, QName name, Object value) throws Exception {
        try {
            this._setter.invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new ConfigException(L.l("Can't assign {0} ({1}) to a {2}.", value, value.getClass(), this._setter.getParameterTypes()[0]));
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.SetterAttributeStrategy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

