/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLibrary {
    private static final L10N L = new L10N(ConfigLibrary._resin_compat_class_0());
    private static final Logger log = Log.open(ConfigLibrary._resin_compat_class_0());
    private static EnvironmentLocal<ConfigLibrary> _localLibrary = new EnvironmentLocal();
    private HashMap<String, Method> _methodMap = new HashMap();
    private static Class _resin_compat_class_0;

    private ConfigLibrary() {
        this.configureLibrary();
    }

    public static ConfigLibrary getLocal() {
        return ConfigLibrary.getLocal(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigLibrary getLocal(ClassLoader loader) {
        loader = ClassLoader.getSystemClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            ConfigLibrary lib = _localLibrary.getLevel(loader);
            if (lib == null) {
                lib = new ConfigLibrary();
                _localLibrary.set(lib, loader);
            }
            ConfigLibrary configLibrary = lib;
            return configLibrary;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public HashMap<String, Method> getMethodMap() {
        return this._methodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLibrary() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            String library = "META-INF/services/com.caucho.config.ConfigLibrary";
            Enumeration<URL> urls = loader.getResources(library);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = null;
                ReadStream rs = null;
                try {
                    is = url.openStream();
                    rs = Vfs.openRead(is);
                    this.parseServicesModule(rs);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void parseServicesModule(ReadStream in) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        String line;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(35);
            if (p >= 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() <= 0) continue;
            String className = line;
            Class<?> cl = Class.forName(className, false, loader);
            this.introspectLibraryClass(cl);
        }
    }

    private void introspectLibraryClass(Class cl) throws IllegalAccessException, InstantiationException {
        log.fine(new CharBuffer().append("Config loading library ").append(cl.getName()).toString());
        for (Method method : cl.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            this._methodMap.put(method.getName(), method);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.ConfigLibrary");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

