/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeStrategy;
import com.caucho.config.ConfigException;
import com.caucho.config.ConfigLibrary;
import com.caucho.config.LineConfigException;
import com.caucho.config.MapBuilder;
import com.caucho.config.NodeBuilder;
import com.caucho.config.TypeStrategy;
import com.caucho.config.TypeStrategyFactory;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.relaxng.Schema;
import com.caucho.relaxng.Verifier;
import com.caucho.relaxng.VerifierFilter;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.util.LruCache;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QDocument;
import com.caucho.xml.QName;
import com.caucho.xml.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final L10N L = new L10N(Config._resin_compat_class_0());
    private static final Logger log = Log.open(Config._resin_compat_class_0());
    private static LruCache<Path, SoftReference<QDocument>> _parseCache = new LruCache(32);
    private HashMap<String, Object> _vars = new HashMap();
    private ClassLoader _classLoader;
    private ConfigLibrary _configLibrary;
    private boolean _allowResinInclude;
    private static Class _resin_compat_class_0;

    public Config() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Config(ClassLoader loader) {
        this._classLoader = loader;
        this._configLibrary = ConfigLibrary.getLocal(this._classLoader);
    }

    public void setResinInclude(boolean useResinInclude) {
        this._allowResinInclude = useResinInclude;
    }

    public Object configure(Object obj, Path path) throws Exception {
        QDocument doc = this.parseDocument(path, null);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, InputStream is) throws Exception {
        QDocument doc = this.parseDocument(is, null);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, Path path, String schemaLocation) throws Exception {
        Schema schema = this.findCompactSchema(schemaLocation);
        QDocument doc = this.parseDocument(path, schema);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, Path path, Schema schema) throws Exception {
        QDocument doc = this.parseDocument(path, schema);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, InputStream is, String schemaLocation) throws Exception {
        Schema schema = this.findCompactSchema(schemaLocation);
        QDocument doc = this.parseDocument(is, schema);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, InputStream is, Schema schema) throws Exception {
        QDocument doc = this.parseDocument(is, schema);
        return this.configure(obj, doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object configure(Object obj, Node topNode) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            NodeBuilder builder = this.createBuilder();
            Object object = builder.configure(obj, topNode);
            return object;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void configureBean(Object obj, Path path, String schemaLocation) throws Exception {
        Schema schema = this.findCompactSchema(schemaLocation);
        QDocument doc = this.parseDocument(path, schema);
        this.configureBean(obj, doc.getDocumentElement());
    }

    public void configureBean(Object obj, Path path) throws Exception {
        QDocument doc = this.parseDocument(path, null);
        this.configureBean(obj, doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureBean(Object obj, Node topNode) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            NodeBuilder builder = this.createBuilder();
            builder.configureBean(obj, topNode);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private NodeBuilder createBuilder() {
        NodeBuilder builder = new NodeBuilder();
        for (String var : this._vars.keySet()) {
            builder.putVar(var, this._vars.get(var));
        }
        ConfigLibrary lib = ConfigLibrary.getLocal();
        HashMap<String, Method> methodMap = lib.getMethodMap();
        for (String var : methodMap.keySet()) {
            builder.putVar(var, methodMap.get(var));
        }
        return builder;
    }

    public void configureBean(Object obj, Path path, Schema schema) throws Exception {
        QDocument doc = this.parseDocument(path, schema);
        this.configureBean(obj, doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QDocument parseDocument(Path path, Schema schema) throws LineConfigException, IOException, SAXException {
        QDocument doc;
        SoftReference docRef = null;
        if (docRef != null && (doc = (QDocument)docRef.get()) != null && !doc.isModified()) {
            return doc;
        }
        ReadStream is = path.openRead();
        try {
            QDocument qDocument = doc = this.parseDocument(is, schema);
            return qDocument;
        }
        finally {
            is.close();
        }
    }

    private QDocument parseDocument(InputStream is, Schema schema) throws LineConfigException, IOException, SAXException {
        QDocument doc = new QDocument();
        DOMBuilder builder = new DOMBuilder();
        builder.init(doc);
        String systemId = null;
        if (is instanceof ReadStream) {
            systemId = ((ReadStream)is).getPath().getUserPath();
        }
        doc.setSystemId(systemId);
        builder.setSystemId(systemId);
        builder.setSkipWhitespace(true);
        InputSource in = new InputSource();
        in.setByteStream(is);
        in.setSystemId(systemId);
        Xml xml = new Xml();
        xml.setOwner(doc);
        xml.setResinInclude(this._allowResinInclude);
        if (schema != null) {
            Verifier verifier = schema.newVerifier();
            VerifierFilter filter = verifier.getVerifierFilter();
            filter.setParent(xml);
            filter.setContentHandler(builder);
            filter.setErrorHandler(builder);
            filter.parse(in);
        } else {
            xml.setContentHandler(builder);
            xml.parse(in);
        }
        return doc;
    }

    private Schema findCompactSchema(String location) throws IOException, ConfigException {
        try {
            if (location == null) {
                return null;
            }
            MergePath schemaPath = new MergePath();
            schemaPath.addClassPath();
            Path path = schemaPath.lookup(location);
            if (path.canRead()) {
                CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
                return factory.compileSchema(path);
            }
            return null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public Object configure(Object obj, Map<String, Object> map) throws Exception {
        new MapBuilder();
        return MapBuilder.configure(obj, map);
    }

    public static void checkCanInstantiate(Class beanClass) throws ConfigException {
        if (beanClass == null) {
            throw new ConfigException(L.l("null classes can't be instantiated."));
        }
        if (beanClass.isInterface()) {
            throw new ConfigException(L.l("`{0}' must be a concrete class.  Interfaces cannot be instantiated.", beanClass.getName()));
        }
        if (!Modifier.isPublic(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class `{0}' is not public.  Bean classes must be public, concrete, and have a zero-argument constructor.", beanClass.getName()));
        }
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class `{0}' is abstract.  Bean classes must be public, concrete, and have a zero-argument constructor.", beanClass.getName()));
        }
        Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            constructor = constructors[i];
            break;
        }
        if (constructor == null) {
            throw new ConfigException(L.l("Custom bean class `{0}' doesn't have a zero-arg constructor.  Bean classes must be have a zero-argument constructor.", beanClass.getName()));
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new ConfigException(L.l("The zero-argument constructor for `{0}' isn't public.  Bean classes must have a public zero-argument constructor.", beanClass.getName()));
        }
    }

    public static void validate(Class cl, Class api) throws ConfigException {
        Config.checkCanInstantiate(cl);
        if (!api.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("{0} must implement {1}.", (Object)cl.getName(), api.getName()));
        }
    }

    public static void setAttribute(Object obj, String attr, Object value) throws Exception {
        TypeStrategy strategy = TypeStrategyFactory.getTypeStrategy(obj.getClass());
        QName attrName = new QName(attr);
        AttributeStrategy attrStrategy = strategy.getAttributeStrategy(attrName);
        attrStrategy.setAttribute(obj, attrName, value);
    }

    public static void init(Object bean) throws Exception {
        TypeStrategy strategy = TypeStrategyFactory.getTypeStrategy(bean.getClass());
        strategy.init(bean);
    }

    public static Object replaceObject(Object bean) throws Exception {
        TypeStrategy strategy = TypeStrategyFactory.getTypeStrategy(bean.getClass());
        return strategy.replaceObject(bean);
    }

    public static VariableResolver getEnvironment() {
        NodeBuilder builder = NodeBuilder.getCurrentBuilder();
        if (builder != null) {
            return builder.getConfigVariableResolver();
        }
        return EL.getEnvironment();
    }

    public static VariableResolver getVariableResolver() {
        NodeBuilder builder = NodeBuilder.getCurrentBuilder();
        if (builder != null) {
            return builder.getConfigVariableResolver();
        }
        return null;
    }

    public void setVar(String var, Object value) {
        Config.setCurrentVar(var, value);
        this._vars.put(var, value);
    }

    public static void setCurrentVar(String var, Object value) {
        NodeBuilder builder = NodeBuilder.getCurrentBuilder();
        if (builder != null) {
            builder.putVar(var, value);
        }
    }

    public static Object getVar(String var) throws ELException {
        return Config.getEnvironment().resolveVariable(var);
    }

    public static String evalString(String str) throws ELException {
        return AttributeStrategy.evalString(str);
    }

    public static String evalString(String str, HashMap<String, Object> varMap) throws ELException {
        return EL.evalString(str, Config.getEnvironment(varMap));
    }

    public static VariableResolver getEnvironment(HashMap<String, Object> varMap) {
        VariableResolver parent = Config.getEnvironment();
        if (varMap != null) {
            return new MapVariableResolver(varMap, parent);
        }
        return parent;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.Config");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

