/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JavaParameterizedType;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class TypeSignatureParser {
    private final JClassLoader _loader;
    private final String _sig;
    private final int _length;
    private int _index;

    public TypeSignatureParser(JClassLoader loader, String sig) {
        this(loader, sig, 0);
    }

    public TypeSignatureParser(JClassLoader loader, String sig, int index) {
        this._loader = loader;
        this._sig = sig;
        this._length = sig.length();
        this._index = index;
    }

    JType nextType() {
        int ch = this.read();
        switch (ch) {
            case -1: {
                return null;
            }
            case 41: 
            case 62: {
                --this._index;
                return null;
            }
            case 86: {
                return JClass.VOID;
            }
            case 90: {
                return JClass.BOOLEAN;
            }
            case 66: {
                return JClass.BYTE;
            }
            case 83: {
                return JClass.SHORT;
            }
            case 73: {
                return JClass.INT;
            }
            case 74: {
                return JClass.LONG;
            }
            case 70: {
                return JClass.FLOAT;
            }
            case 68: {
                return JClass.DOUBLE;
            }
            case 67: {
                return JClass.CHAR;
            }
            case 76: {
                return this.parseClass();
            }
        }
        throw new IllegalStateException(new CharBuffer().append("Can't parse: ").append(this._sig).toString());
    }

    private JType parseClass() {
        int begin;
        int end = begin = this._index;
        int ch = this.read();
        while (ch >= 0 && ch != 59 && ch != 41 && ch != 44 && ch != 60 && ch != 62) {
            end = this._index;
            ch = this.read();
        }
        String className = this._sig.substring(begin, end).replace('/', '.');
        JClass rawClass = this._loader.forName(className);
        if (ch == 60) {
            return this.parseParameterizedType(rawClass);
        }
        return rawClass;
    }

    private JType parseParameterizedType(JClass rawClass) {
        JType type;
        ArrayList<JType> argList = new ArrayList<JType>();
        while ((type = this.nextType()) != null) {
            argList.add(type);
        }
        int ch = this.read();
        if (ch != 62) {
            throw new IllegalStateException(new CharBuffer().append("expected '>' at ").append((char)ch).toString());
        }
        JType[] args = new JType[argList.size()];
        argList.toArray(args);
        return new JavaParameterizedType(this._loader, rawClass, args);
    }

    private int read() {
        if (this._index < this._length) {
            return this._sig.charAt(this._index++);
        }
        return -1;
    }
}

