/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.util.logging.Logger;

public class StringConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(StringConstant._resin_compat_class_0());
    private int _stringIndex;
    private static Class _resin_compat_class_0;

    StringConstant(ConstantPool pool, int index, int stringIndex) {
        super(pool, index);
        this._stringIndex = stringIndex;
    }

    public String getString() {
        return this.getConstantPool().getUtf8(this._stringIndex).getValue();
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(8);
        out.writeShort(this._stringIndex);
    }

    public int export(ConstantPool target) {
        return target.addString(this.getString()).getIndex();
    }

    public String toString() {
        return new CharBuffer().append("StringConstant[").append(this.getString()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.StringConstant");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

