/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.util.logging.Logger;

public class LongConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(LongConstant._resin_compat_class_0());
    private long _value;
    private static Class _resin_compat_class_0;

    LongConstant(ConstantPool pool, int index, long value) {
        super(pool, index);
        this._value = value;
    }

    public long getValue() {
        return this._value;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(5);
        out.writeLong(this._value);
    }

    public int export(ConstantPool target) {
        return target.addLong(this._value).getIndex();
    }

    public String toString() {
        return new CharBuffer().append("LongConstant[").append(this._value).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.LongConstant");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

