/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.TypeSignatureParser;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.net.URL;
import java.util.logging.Logger;

public class JavaClassLoader
extends JClassLoader {
    protected static final L10N L = new L10N(JavaClassLoader._resin_compat_class_0());
    protected static final Logger log = Logger.getLogger(JavaClassLoader._resin_compat_class_0().getName());
    private ClassLoader _loader;
    private static Class _resin_compat_class_0;

    public JavaClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JavaClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    protected JClass loadClass(String name) {
        if (name.startsWith("java")) {
            return JavaClassLoader.getStaticClassLoader().forName(name);
        }
        String classPath = new CharBuffer().append(name.replace('.', '/')).append(".class").toString();
        URL url = this._loader.getResource(classPath);
        if (url != null) {
            JavaClass jClass = new JavaClass(this);
            jClass.setURL(url);
            jClass.setThisClass(name.replace('.', '/'));
            return jClass;
        }
        return null;
    }

    protected JType parseParameterizedType(String type) {
        return new TypeSignatureParser(this, type).nextType();
    }

    public String toString() {
        return "JavaClassLoader[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.JavaClassLoader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

