/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JAccessibleObject;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JType;
import com.caucho.util.CharBuffer;

public abstract class JMethod
extends JAccessibleObject {
    public abstract String getName();

    public abstract boolean isStatic();

    public abstract boolean isPublic();

    public abstract boolean isAbstract();

    public abstract boolean isFinal();

    public abstract JClass getDeclaringClass();

    public abstract JClass getReturnType();

    public abstract JType getGenericReturnType();

    public abstract JClass[] getParameterTypes();

    public abstract JClass[] getExceptionTypes();

    public abstract JAnnotation[] getDeclaredAnnotations();

    public String getFullName() {
        CharBuffer name = new CharBuffer();
        name.append(this.getName());
        name.append("(");
        JClass[] params = this.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                name.append(", ");
            }
            name.append(params[i].getShortName());
        }
        name.append(')');
        return name.toString();
    }

    public boolean equals(Object o) {
        JClass[] bParam;
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JMethod jMethod = (JMethod)o;
        if (!this.getName().equals(jMethod.getName())) {
            return false;
        }
        JClass[] aParam = this.getParameterTypes();
        if (aParam.length != (bParam = jMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < aParam.length; ++i) {
            if (aParam[i].equals(bParam[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new CharBuffer().append("JMethod[").append(this.getName()).append("]").toString();
    }
}

