/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.make.PersistentDependency;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JClassDependency
implements PersistentDependency {
    private static final Logger log = Log.open(JClassDependency._resin_compat_class_0());
    private String _className;
    private boolean _checkFields = true;
    private boolean _checkStatic = true;
    private boolean _checkProtected = true;
    private boolean _checkPrivate = true;
    private boolean _isDigestModified;
    private static Class _resin_compat_class_0;

    public JClassDependency(JClass cl) {
        this._className = cl.getName();
    }

    public JClassDependency(JClass cl, String digest) {
        this._className = cl.getName();
        String newDigest = this.getDigest();
        if (!newDigest.equals(digest)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._className).append(" digest is modified.").toString());
            }
            this._isDigestModified = true;
        }
    }

    public JClassDependency(String className, String digest) {
    }

    public boolean isModified() {
        return this._isDigestModified;
    }

    public String getDigest() {
        return "";
    }

    public String getJavaCreateString() {
        return new CharBuffer().append("new com.caucho.bytecode.JClassDependency(\"").append(this._className).append("\", \"").append(this.getDigest()).append("\")").toString();
    }

    private static void addDigest(MessageDigest digest, int v) {
        digest.update((byte)(v >> 24));
        digest.update((byte)(v >> 16));
        digest.update((byte)(v >> 8));
        digest.update((byte)v);
    }

    private static void addDigest(MessageDigest digest, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                digest.update((byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                digest.update((byte)(192 + (ch >> 6)));
                digest.update((byte)(128 + (ch & 0x3F)));
                continue;
            }
            digest.update((byte)(224 + (ch >> 12)));
            digest.update((byte)(128 + (ch >> 6 & 0x3F)));
            digest.update((byte)(128 + (ch & 0x3F)));
        }
    }

    private String digestToBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.encode(cb, digest, 0, len);
        return cb.close();
    }

    public boolean isEqual(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JClassDependency)) {
            return false;
        }
        JClassDependency depend = (JClassDependency)o;
        return this._className.equals(depend._className);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.JClassDependency");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodComparator
    implements Comparator<JMethod> {
        MethodComparator() {
        }

        @Override
        public int compare(JMethod a, JMethod b) {
            JClass[] paramB;
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            JClass[] paramA = a.getParameterTypes();
            if (paramA.length < (paramB = b.getParameterTypes()).length) {
                return -1;
            }
            if (paramB.length < paramA.length) {
                return 1;
            }
            for (int i = 0; i < paramA.length; ++i) {
                cmp = paramA[i].getName().compareTo(paramB[i].getName());
                if (cmp == 0) continue;
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getReturnType().getName().compareTo(b.getReturnType().getName());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldComparator
    implements Comparator<JField> {
        FieldComparator() {
        }

        @Override
        public int compare(JField a, JField b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getType().getName().compareTo(b.getType().getName());
        }
    }
}

