/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JAnnotationObject;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.util.CharBuffer;

public abstract class JClass
extends JAnnotationObject
implements JType {
    public static final JClass VOID = new JClassWrapper(Void.TYPE);
    public static final JClass BOOLEAN = new JClassWrapper(Boolean.TYPE);
    public static final JClass BYTE = new JClassWrapper(Byte.TYPE);
    public static final JClass SHORT = new JClassWrapper(Short.TYPE);
    public static final JClass INT = new JClassWrapper(Integer.TYPE);
    public static final JClass LONG = new JClassWrapper(Long.TYPE);
    public static final JClass FLOAT = new JClassWrapper(Float.TYPE);
    public static final JClass DOUBLE = new JClassWrapper(Double.TYPE);
    public static final JClass CHAR = new JClassWrapper(Character.TYPE);
    public static final JClass STRING = new JClassWrapper(JClass._resin_compat_class_0());
    public static final JClass OBJECT = new JClassWrapper(JClass._resin_compat_class_1());
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public abstract String getName();

    public Class getJavaClass() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Class.forName(this.getName(), false, loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JType[] getActualTypeArguments() {
        return new JType[0];
    }

    public JClass getRawType() {
        return this;
    }

    public abstract boolean isPrimitive();

    public abstract boolean isPublic();

    public abstract boolean isAbstract();

    public abstract boolean isFinal();

    public abstract boolean isInterface();

    public abstract JClass getSuperClass();

    public abstract JClass[] getInterfaces();

    public abstract boolean isArray();

    public JClass getComponentType() {
        return null;
    }

    public abstract boolean isAssignableTo(Class var1);

    public abstract boolean isAssignableFrom(Class var1);

    public abstract boolean isAssignableFrom(JClass var1);

    public abstract JMethod[] getDeclaredMethods();

    public abstract JMethod[] getMethods();

    public abstract JMethod[] getConstructors();

    public JMethod getConstructor(JClass[] param) {
        JMethod[] ctors = this.getConstructors();
        block0: for (int i = 0; i < ctors.length; ++i) {
            JClass[] args = ctors[i].getParameterTypes();
            if (args.length != param.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (!args[i].equals(param[j])) continue block0;
            }
            return ctors[i];
        }
        return null;
    }

    public abstract JMethod getMethod(String var1, JClass[] var2);

    public abstract JField[] getDeclaredFields();

    public abstract JField[] getFields();

    public String getPrintName() {
        if (this.isArray()) {
            return new CharBuffer().append(this.getComponentType().getPrintName()).append("[]").toString();
        }
        return this.getName().replace('$', '.');
    }

    public String getShortName() {
        if (this.isArray()) {
            return new CharBuffer().append(this.getComponentType().getShortName()).append("[]").toString();
        }
        String name = this.getName().replace('$', '.');
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            return name.substring(p + 1);
        }
        return name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JClass jClass = (JClass)o;
        return this.getName().equals(jClass.getName());
    }

    public String toString() {
        return new CharBuffer().append("JClass[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

