/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ClassConstant;
import com.caucho.bytecode.CodeEnhancer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAttribute
extends Attribute {
    private static final Logger log = Log.open(CodeAttribute._resin_compat_class_0());
    private int _maxStack;
    private int _maxLocals;
    private byte[] _code;
    private ArrayList<ExceptionItem> _exceptions = new ArrayList();
    private ArrayList<Attribute> _attributes = new ArrayList();
    private static Class _resin_compat_class_0;

    public CodeAttribute() {
        super("Code");
    }

    CodeAttribute(String name) {
        super(name);
    }

    public int getMaxLocals() {
        return this._maxLocals;
    }

    public void setMaxLocals(int max) {
        this._maxLocals = max;
    }

    public int getMaxStack() {
        return this._maxStack;
    }

    public void setMaxStack(int max) {
        this._maxStack = max;
    }

    public void setCode(byte[] code) {
        this._code = code;
    }

    public byte[] getCode() {
        return this._code;
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
    }

    public ArrayList<Attribute> getAttributes() {
        return this._attributes;
    }

    public void setAttributes(ArrayList<Attribute> attributes) {
        if (this._attributes != attributes) {
            this._attributes.clear();
            this._attributes.addAll(attributes);
        }
    }

    public ArrayList<ExceptionItem> getExceptions() {
        return this._exceptions;
    }

    public void addException(ClassConstant type, int start, int end, int handler) {
        this._exceptions.add(new ExceptionItem(type.getIndex(), start, end, handler));
    }

    public void read(ByteCodeParser in) throws IOException {
        int length = in.readInt();
        this._maxStack = in.readShort();
        this._maxLocals = in.readShort();
        int codeLength = in.readInt();
        this._code = new byte[codeLength];
        in.read(this._code, 0, codeLength);
        int exnCount = in.readShort();
        for (int i = 0; i < exnCount; ++i) {
            ExceptionItem exn = new ExceptionItem();
            exn.setStart(in.readShort() & 0xFFFF);
            exn.setEnd(in.readShort() & 0xFFFF);
            exn.setHandler(in.readShort() & 0xFFFF);
            exn.setType(in.readShort() & 0xFFFF);
            this._exceptions.add(exn);
        }
        int attrCount = in.readShort();
        for (int i = 0; i < attrCount; ++i) {
            Attribute attr = in.parseAttribute();
            this._attributes.add(attr);
        }
    }

    @Override
    public void write(ByteCodeWriter out) throws IOException {
        int i;
        out.writeUTF8Const(this.getName());
        TempStream ts = new TempStream();
        ts.openWrite();
        WriteStream ws = new WriteStream(ts);
        ByteCodeWriter o2 = new ByteCodeWriter(ws, out.getJavaClass());
        o2.writeShort(this._maxStack);
        o2.writeShort(this._maxLocals);
        o2.writeInt(this._code.length);
        o2.write(this._code, 0, this._code.length);
        o2.writeShort(this._exceptions.size());
        for (i = 0; i < this._exceptions.size(); ++i) {
            ExceptionItem exn = this._exceptions.get(i);
            o2.writeShort(exn.getStart());
            o2.writeShort(exn.getEnd());
            o2.writeShort(exn.getHandler());
            o2.writeShort(exn.getType());
        }
        o2.writeShort(this._attributes.size());
        for (i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(o2);
        }
        ws.close();
        out.writeInt(ts.getLength());
        for (TempBuffer ptr = ts.getHead(); ptr != null; ptr = ptr.getNext()) {
            out.write(ptr.getBuffer(), 0, ptr.getLength());
        }
        ts.destroy();
    }

    @Override
    public Attribute export(JavaClass source, JavaClass target) {
        int i;
        ConstantPool cp = target.getConstantPool();
        cp.addUTF8(this.getName());
        CodeAttribute attr = new CodeAttribute(this.getName());
        attr._maxStack = this._maxStack;
        attr._maxLocals = this._maxLocals;
        byte[] code = new byte[this._code.length];
        System.arraycopy(this._code, 0, code, 0, this._code.length);
        attr._code = code;
        for (i = 0; i < this._exceptions.size(); ++i) {
            ExceptionItem exn = this._exceptions.get(i);
            int type = exn.getType();
            if (type != 0) {
                type = cp.addClass(source.getConstantPool().getClass(type).getName()).getIndex();
            }
            ExceptionItem newExn = new ExceptionItem(type, exn.getStart(), exn.getEnd(), exn.getHandler());
            attr._exceptions.add(newExn);
        }
        for (i = 0; i < this._attributes.size(); ++i) {
            Attribute codeAttr = this._attributes.get(i);
            attr.addAttribute(codeAttr.export(source, target));
        }
        try {
            attr.exportCode(source, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return attr;
    }

    public void exportCode(JavaClass source, JavaClass target) throws Exception {
        ExportAnalyzer analyzer = new ExportAnalyzer(source, target);
        CodeEnhancer visitor = new CodeEnhancer(source, this);
        visitor.analyze(analyzer, false);
        visitor.update();
    }

    @Override
    public String toString() {
        return new CharBuffer().append("CodeAttribute[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.CodeAttribute");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class ExportAnalyzer
    extends Analyzer {
        private JavaClass _source;
        private JavaClass _target;

        public ExportAnalyzer(JavaClass source, JavaClass target) {
            this._source = source;
            this._target = target;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            int op = visitor.getOpcode();
            ConstantPool sourcePool = this._source.getConstantPool();
            ConstantPool targetPool = this._target.getConstantPool();
            switch (op) {
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    int index = visitor.getShortArg(1);
                    ConstantPoolEntry entry = sourcePool.getEntry(index);
                    int targetIndex = entry.export(targetPool);
                    visitor.setShortArg(1, targetIndex);
                    break;
                }
                case 18: {
                    int index = visitor.getByteArg(1);
                    ConstantPoolEntry entry = sourcePool.getEntry(index);
                    index = entry.export(targetPool);
                    if (index <= 255) {
                        visitor.setByteArg(1, index);
                        break;
                    }
                    CodeEnhancer enhancer = (CodeEnhancer)visitor;
                    enhancer.setByteArg(0, 19);
                    enhancer.addByte(enhancer.getOffset() + 2, 0);
                    enhancer.setShortArg(1, index);
                    break;
                }
            }
        }
    }

    public static class ExceptionItem {
        private int _type;
        private int _start;
        private int _end;
        private int _handler;

        public ExceptionItem() {
        }

        public ExceptionItem(int type, int start, int end, int handler) {
            this._type = type;
            this._start = start;
            this._end = end;
            this._handler = handler;
        }

        public void setType(int type) {
            this._type = type;
        }

        public int getType() {
            return this._type;
        }

        public void setStart(int pc) {
            this._start = pc;
        }

        public int getStart() {
            return this._start;
        }

        public void setEnd(int pc) {
            this._end = pc;
        }

        public int getEnd() {
            return this._end;
        }

        public void setHandler(int pc) {
            this._handler = pc;
        }

        public int getHandler() {
            return this._handler;
        }
    }
}

