/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.BigDecimalType;
import com.caucho.amber.type.BlobType;
import com.caucho.amber.type.BooleanType;
import com.caucho.amber.type.ByteArrayType;
import com.caucho.amber.type.ByteType;
import com.caucho.amber.type.CalendarType;
import com.caucho.amber.type.CharacterType;
import com.caucho.amber.type.ClassType;
import com.caucho.amber.type.ClobType;
import com.caucho.amber.type.DoubleType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.FloatType;
import com.caucho.amber.type.IntegerType;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.PrimitiveBooleanType;
import com.caucho.amber.type.PrimitiveByteType;
import com.caucho.amber.type.PrimitiveCharType;
import com.caucho.amber.type.PrimitiveDoubleType;
import com.caucho.amber.type.PrimitiveFloatType;
import com.caucho.amber.type.PrimitiveIntType;
import com.caucho.amber.type.PrimitiveLongType;
import com.caucho.amber.type.PrimitiveShortType;
import com.caucho.amber.type.ShortType;
import com.caucho.amber.type.SqlDateType;
import com.caucho.amber.type.SqlTimeType;
import com.caucho.amber.type.SqlTimestampType;
import com.caucho.amber.type.StringType;
import com.caucho.amber.type.TrueFalseType;
import com.caucho.amber.type.Type;
import com.caucho.amber.type.UtilDateType;
import com.caucho.amber.type.YesNoType;
import com.caucho.bytecode.JClass;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Iterator;

public class TypeManager {
    private static final L10N L = new L10N(TypeManager._resin_compat_class_0());
    private static HashMap<String, Type> _builtinTypes = new HashMap();
    private static HashMap<String, Type> _primitiveTypes;
    private HashMap<String, Type> _typeMap = new HashMap();
    private static Class _resin_compat_class_0;

    public TypeManager() {
        this._typeMap.putAll(_builtinTypes);
    }

    public Type create(String name) throws ConfigException {
        Type type = this._typeMap.get(name);
        if (type != null) {
            return type;
        }
        throw new ConfigException(L.l("'{0}' is an unknown type", name));
    }

    public Type create(JClass cl) throws ConfigException {
        Type type = _primitiveTypes.get(cl.getName());
        if (type != null) {
            return type;
        }
        type = this._typeMap.get(cl.getName());
        return type;
    }

    public Type get(String name) {
        return this._typeMap.get(name);
    }

    public EntityType getEntityByInstanceClass(String name) {
        Iterator<Type> i$ = this._typeMap.values().iterator();
        while (i$.hasNext()) {
            EntityType entityType;
            Type type = i$.next();
            if (!(type instanceof EntityType) || !name.equals((entityType = (EntityType)type).getInstanceClassName())) continue;
            return entityType;
        }
        return null;
    }

    public void put(String name, Type type) {
        Type oldType = this._typeMap.get(name);
        if (oldType != null && oldType != type) {
            throw new IllegalStateException(L.l("'{0}' is a duplicate type", name));
        }
        this._typeMap.put(name, type);
    }

    static {
        _builtinTypes.put("boolean", BooleanType.create());
        _builtinTypes.put("java.lang.Boolean", BooleanType.create());
        _builtinTypes.put("yes_no", YesNoType.create());
        _builtinTypes.put("true_false", TrueFalseType.create());
        _builtinTypes.put("byte", ByteType.create());
        _builtinTypes.put("java.lang.Byte", ByteType.create());
        _builtinTypes.put("character", CharacterType.create());
        _builtinTypes.put("java.lang.Character", CharacterType.create());
        _builtinTypes.put("short", ShortType.create());
        _builtinTypes.put("java.lang.Short", ShortType.create());
        _builtinTypes.put("integer", IntegerType.create());
        _builtinTypes.put("java.lang.Integer", IntegerType.create());
        _builtinTypes.put("long", LongType.create());
        _builtinTypes.put("java.lang.Long", LongType.create());
        _builtinTypes.put("float", FloatType.create());
        _builtinTypes.put("java.lang.Float", FloatType.create());
        _builtinTypes.put("double", DoubleType.create());
        _builtinTypes.put("java.lang.Double", DoubleType.create());
        _builtinTypes.put("string", StringType.create());
        _builtinTypes.put("java.lang.String", StringType.create());
        _builtinTypes.put("date", SqlDateType.create());
        _builtinTypes.put("java.sql.Date", SqlDateType.create());
        _builtinTypes.put("time", SqlTimeType.create());
        _builtinTypes.put("java.sql.Time", SqlTimeType.create());
        _builtinTypes.put("timestamp", SqlTimestampType.create());
        _builtinTypes.put("java.sql.Timestamp", SqlTimestampType.create());
        _builtinTypes.put("java.util.Date", UtilDateType.create());
        _builtinTypes.put("java.util.Calendar", CalendarType.create());
        _builtinTypes.put("timestamp", BigDecimalType.create());
        _builtinTypes.put("java.math.BigDecimal", BigDecimalType.create());
        _builtinTypes.put("blob", BlobType.create());
        _builtinTypes.put("java.sql.Blob", BlobType.create());
        _builtinTypes.put("clob", BlobType.create());
        _builtinTypes.put("java.sql.Clob", ClobType.create());
        _builtinTypes.put("[B", ByteArrayType.create());
        _builtinTypes.put("[byte", ByteArrayType.create());
        _builtinTypes.put("class", ClassType.create());
        _builtinTypes.put("java.lang.Class", ClassType.create());
        _primitiveTypes = new HashMap();
        _primitiveTypes.put("boolean", PrimitiveBooleanType.create());
        _primitiveTypes.put("char", PrimitiveCharType.create());
        _primitiveTypes.put("byte", PrimitiveByteType.create());
        _primitiveTypes.put("short", PrimitiveShortType.create());
        _primitiveTypes.put("int", PrimitiveIntType.create());
        _primitiveTypes.put("long", PrimitiveLongType.create());
        _primitiveTypes.put("float", PrimitiveFloatType.create());
        _primitiveTypes.put("double", PrimitiveDoubleType.create());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.TypeManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

