/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TrueFalseType
extends Type {
    private static final L10N L = new L10N(TrueFalseType._resin_compat_class_0());
    private static final TrueFalseType TRUE_FALSE_TYPE = new TrueFalseType();
    private static Class _resin_compat_class_0;

    private TrueFalseType() {
    }

    public static TrueFalseType create() {
        return TRUE_FALSE_TYPE;
    }

    public String getName() {
        return "java.lang.Boolean";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.ormap.amber.TrueFalseType.toBoolean(").append(rs).append(".getString(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, 0);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setString(").append(index).append("++, ").append(value).append(".booleanValue() ? \"y\" : \"n\");").toString());
    }

    public static Boolean toBoolean(String value, boolean wasNull) {
        if (value == null) {
            return null;
        }
        if ("t".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("f".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        String value = rs.getString(index);
        if (value == null) {
            return null;
        }
        if ("t".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("f".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.TrueFalseType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

