/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StringType
extends Type {
    private static final L10N L = new L10N(StringType._resin_compat_class_0());
    private static final StringType STRING_TYPE = new StringType();
    private static Class _resin_compat_class_0;

    private StringType() {
    }

    public static StringType create() {
        return STRING_TYPE;
    }

    public String getName() {
        return "java.lang.String";
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        if (length == 0) {
            length = 255;
        }
        return new CharBuffer().append("VARCHAR(").append(length).append(")").toString();
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getString(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setString(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setString(index, (String)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getString(index);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.StringType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

