/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ShortType
extends Type {
    private static final L10N L = new L10N(ShortType._resin_compat_class_0());
    private static final ShortType SHORT_TYPE = new ShortType();
    private static Class _resin_compat_class_0;

    private ShortType() {
    }

    public static ShortType create() {
        return SHORT_TYPE;
    }

    public String getName() {
        return "java.lang.Short";
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(5, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.ShortType.toShort(").append(rs).append(".getShort(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.SMALLINT);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setShort(").append(index).append("++, ").append(value).append(".shortValue());").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.SMALLINT);").toString());
    }

    public Object toObject(long value) {
        return new Short((short)value);
    }

    public static Short toShort(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Short((short)value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 0);
        } else {
            pstmt.setShort(index, ((Number)value).shortValue());
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        short value = rs.getShort(index);
        return rs.wasNull() ? null : new Short(value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.ShortType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

