/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.FloatType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class PrimitiveFloatType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveFloatType._resin_compat_class_0());
    private static final PrimitiveFloatType FLOAT_TYPE = new PrimitiveFloatType();
    private static Class _resin_compat_class_0;

    private PrimitiveFloatType() {
    }

    public static PrimitiveFloatType create() {
        return FLOAT_TYPE;
    }

    public String getName() {
        return "float";
    }

    public Type getForeignType() {
        return FloatType.create();
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(7, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getFloat(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setFloat(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.REAL);").toString());
    }

    public String toObject(String value) {
        return new CharBuffer().append("new Float(").append(value).append(")").toString();
    }

    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((Number) ").append(value).append(").floatValue()").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.PrimitiveFloatType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

