/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.BooleanType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class PrimitiveBooleanType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveBooleanType._resin_compat_class_0());
    private static final PrimitiveBooleanType BOOLEAN_TYPE = new PrimitiveBooleanType();
    private static Class _resin_compat_class_0;

    private PrimitiveBooleanType() {
    }

    public static PrimitiveBooleanType create() {
        return BOOLEAN_TYPE;
    }

    public String getName() {
        return "boolean";
    }

    public Type getForeignType() {
        return BooleanType.create();
    }

    public boolean isBoolean() {
        return true;
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(16, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getBoolean(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setBoolean(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.BIT);").toString());
    }

    public String toObject(String value) {
        return new CharBuffer().append("((").append(value).append(") ? Boolean.TRUE : Boolean.FALSE)").toString();
    }

    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((Boolean) ").append(value).append(").booleanValue()").toString();
    }

    public String generateIsNull(String value) {
        return new CharBuffer().append("! (").append(value).append(")").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.PrimitiveBooleanType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

