/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.AmberFieldCompare;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.StubMethod;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.SubEntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassDependency;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.make.ClassDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityType
extends Type {
    private static final Logger log;
    private static final L10N L;
    private AmberManager _amberManager;
    private String _name;
    private Table _table;
    private ArrayList<Table> _secondaryTables = new ArrayList();
    private Id _id;
    private Column _discriminator;
    private String _discriminatorValue;
    private boolean _isJoinedSubClass;
    private ArrayList<AmberField> _fields = new ArrayList();
    private HashMap<String, EntityType> _subEntities;
    private JClass _beanClass;
    private boolean _isFieldAccess;
    private String _instanceClassName;
    private boolean _isEnhanced;
    private ClassLoader _instanceLoader;
    private Class _instanceClass;
    private JClass _proxyClass;
    private AmberEntityHome _home;
    private ArrayList<StubMethod> _methods = new ArrayList();
    protected int _defaultLoadGroupIndex;
    protected int _loadGroupIndex;
    protected int _dirtyIndex;
    protected boolean _hasLoadCallback;
    private HashMap<String, IdGenerator> _idGenMap = new HashMap();
    private ArrayList<PersistentDependency> _dependencies = new ArrayList();
    private ArrayList<JMethod> _prePersistCallbacks = new ArrayList();
    private ArrayList<JMethod> _postPersistCallbacks = new ArrayList();
    private final Lifecycle _lifecycle = new Lifecycle();
    private volatile boolean _isConfigured;
    private volatile boolean _isGenerated;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public EntityType(AmberManager amberManager) {
        this._amberManager = amberManager;
    }

    public AmberManager getAmberManager() {
        return this._amberManager;
    }

    public Table getTable() {
        if (this._table == null) {
            this.setTable(this._amberManager.createTable(this.getName()));
        }
        return this._table;
    }

    public void setTable(Table table) {
        this._table = table;
        table.setType(this);
    }

    public void addSecondaryTable(Table table) {
        if (!this._secondaryTables.contains(table)) {
            this._secondaryTables.add(table);
        }
        table.setType(this);
    }

    public ArrayList<Table> getSecondaryTables() {
        return this._secondaryTables;
    }

    public Table getSecondaryTable(String name) {
        for (Table table : this._secondaryTables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public void setFieldAccess(boolean isFieldAccess) {
        this._isFieldAccess = isFieldAccess;
    }

    public boolean isFieldAccess() {
        return this._isFieldAccess;
    }

    @Override
    public String getJavaTypeName() {
        return this.getInstanceClassName();
    }

    @Override
    public String getForeignTypeName() {
        return this.getId().getForeignTypeName();
    }

    public void setBeanClass(JClass beanClass) {
        this._beanClass = beanClass;
        if (this.getName() == null) {
            String name = beanClass.getName();
            int p = name.lastIndexOf(46);
            if (p > 0) {
                name = name.substring(p + 1);
            }
            this.setName(name);
        }
        this.addDependency(this._beanClass);
    }

    public JClass getBeanClass() {
        return this._beanClass;
    }

    public JClass getProxyClass() {
        if (this._proxyClass != null) {
            return this._proxyClass;
        }
        return this._beanClass;
    }

    public void setProxyClass(JClass proxyClass) {
        this._proxyClass = proxyClass;
    }

    public boolean isInit() {
        return this._instanceClass != null;
    }

    public void setInstanceClassName(String className) {
        this._instanceClassName = className;
    }

    public String getInstanceClassName() {
        return this._instanceClassName;
    }

    public void setEnhanced(boolean isEnhanced) {
        this._isEnhanced = isEnhanced;
    }

    public boolean isEnhanced() {
        return this._isEnhanced;
    }

    public void setInstanceClassLoader(ClassLoader loader) {
        this._instanceLoader = loader;
    }

    public Class getInstanceClass() {
        if (this._instanceClass == null) {
            if (this.getInstanceClassName() == null) {
                throw new RuntimeException(new CharBuffer().append("No instance class:").append(this).toString());
            }
            try {
                if (this._isEnhanced) {
                    ClassLoader loader = this.getAmberManager().getEnhancedLoader();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(L.l("loading bean class `{0}' from `{1}'", (Object)this.getBeanClass().getName(), loader));
                    }
                    this._instanceClass = Class.forName(this.getBeanClass().getName(), false, loader);
                } else {
                    ClassLoader loader = this._instanceLoader;
                    if (loader == null) {
                        loader = this.getAmberManager().getEnhancedLoader();
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(L.l("loading instance class `{0}' from `{1}'", (Object)this.getInstanceClassName(), loader));
                    }
                    this._instanceClass = Class.forName(this.getInstanceClassName(), false, loader);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (!EntityType._resin_compat_class_0().isAssignableFrom(this._instanceClass)) {
                throw new AmberRuntimeException(L.l("'{0}' with classloader {1} is an illegal instance class", (Object)this._instanceClass.getName(), this._instanceClass.getClassLoader()));
            }
        }
        return this._instanceClass;
    }

    public boolean isGenerated() {
        return this._isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        if (this.isEnhanced()) {
            this._isGenerated = isGenerated;
        }
    }

    public void setId(Id id) {
        this._id = id;
    }

    public Id getId() {
        return this._id;
    }

    public Column getDiscriminator() {
        return this._discriminator;
    }

    public void setDiscriminator(Column discriminator) {
        this._discriminator = discriminator;
    }

    public void setJoinedSubClass(boolean isJoinedSubClass) {
        this._isJoinedSubClass = isJoinedSubClass;
    }

    public boolean isJoinedSubClass() {
        if (this.getParentType() != null) {
            return this.getParentType().isJoinedSubClass();
        }
        return this._isJoinedSubClass;
    }

    public String getDiscriminatorValue() {
        if (this._discriminatorValue != null) {
            return this._discriminatorValue;
        }
        String name = this.getBeanClass().getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            return name.substring(0, p);
        }
        return name;
    }

    public void setDiscriminatorValue(String value) {
        this._discriminatorValue = value;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this.getTable().isReadOnly();
    }

    public void setReadOnly(boolean isReadOnly) {
        this.getTable().setReadOnly(isReadOnly);
    }

    public long getCacheTimeout() {
        return this.getTable().getCacheTimeout();
    }

    public void setCacheTimeout(long timeout) {
        this.getTable().setCacheTimeout(timeout);
    }

    public void addField(AmberField field) {
        this._fields.add(field);
        Collections.sort(this._fields, new AmberFieldCompare());
    }

    public ArrayList<AmberField> getFields() {
        return this._fields;
    }

    public AmberField getField(String name) {
        if (this._id != null) {
            ArrayList<IdField> keys = this._id.getKeys();
            for (int i = 0; i < keys.size(); ++i) {
                IdField key = keys.get(i);
                if (!key.getName().equals(name)) continue;
                return key;
            }
        }
        for (int i = 0; i < this._fields.size(); ++i) {
            AmberField field = this._fields.get(i);
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public ArrayList<Column> getColumns() {
        return this.getTable().getColumns();
    }

    public void setHasLoadCallback(boolean hasCallback) {
        this._hasLoadCallback = hasCallback;
    }

    public boolean getHasLoadCallback() {
        return this._hasLoadCallback;
    }

    public EntityType getRootType() {
        EntityType parent = this.getParentType();
        if (parent != null) {
            return parent.getRootType();
        }
        return this;
    }

    public EntityType getParentType() {
        return null;
    }

    public void addSubClass(SubEntityType type) {
        if (this._subEntities == null) {
            this._subEntities = new HashMap();
        }
        this._subEntities.put(type.getDiscriminatorValue(), type);
    }

    public EntityType getSubClass(String discriminator) {
        if (this._subEntities == null) {
            return this;
        }
        EntityType subType = this._subEntities.get(discriminator);
        if (subType != null) {
            return subType;
        }
        return this;
    }

    public void addPrePersistCallback(JMethod callback) {
        this._prePersistCallbacks.add(callback);
    }

    public ArrayList<JMethod> getPrePersistCallbacks() {
        return this._prePersistCallbacks;
    }

    public void addPostPersistCallback(JMethod callback) {
        this._postPersistCallbacks.add(callback);
    }

    public ArrayList<JMethod> getPostPersistCallbacks() {
        return this._postPersistCallbacks;
    }

    public Entity createBean() {
        try {
            return (Entity)this.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public void addStubMethod(StubMethod method) {
        this._methods.add(method);
    }

    public ArrayList<StubMethod> getMethods() {
        return this._methods;
    }

    public void addDependency(Class cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public void addDependency(JClass cl) {
        this.addDependency(new JClassDependency(cl));
    }

    public void addDependency(PersistentDependency depend) {
        if (!this._dependencies.contains(depend)) {
            this._dependencies.add(depend);
        }
    }

    public ArrayList<PersistentDependency> getDependencies() {
        return this._dependencies;
    }

    public AmberEntityHome getHome() {
        if (this._home == null) {
            this._home = this.getAmberManager().getEntityHome(this.getName());
        }
        return this._home;
    }

    public int nextLoadGroupIndex() {
        return ++this._loadGroupIndex;
    }

    public int getLoadGroupIndex() {
        return this._loadGroupIndex;
    }

    public void nextDefaultLoadGroupIndex() {
        this._defaultLoadGroupIndex = this.nextLoadGroupIndex();
    }

    public int getDefaultLoadGroupIndex() {
        return this._defaultLoadGroupIndex;
    }

    public int nextDirtyIndex() {
        return this._dirtyIndex++;
    }

    public int getDirtyIndex() {
        return this._dirtyIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startConfigure() {
        EntityType entityType = this;
        synchronized (entityType) {
            if (this._isConfigured) {
                return false;
            }
            this._isConfigured = true;
            return true;
        }
    }

    @Override
    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
        this.getTable();
        for (AmberField field : this._fields) {
            if (field.isUpdateable()) {
                field.setIndex(this.nextDirtyIndex());
            }
            field.init();
        }
        if (!$assertionsDisabled && this.getId() == null) {
            throw new AssertionError((Object)new CharBuffer().append("null id for ").append(this._name).toString());
        }
        this.getId().init();
    }

    public void start() throws ConfigException {
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
    }

    @Override
    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((").append(this.getInstanceClassName()).append(") ").append(value).append(")").toString();
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("aConn.loadProxy(\"").append(this.getName()).append("\", ").toString());
        index = this.getId().generateLoadForeign(out, rs, indexVar, index);
        out.println(");");
        return index;
    }

    public boolean hasLoadGroup(int loadGroupIndex) {
        if (loadGroupIndex == 0) {
            return true;
        }
        for (AmberField field : this.getFields()) {
            if (!field.hasLoadGroup(loadGroupIndex)) continue;
            return true;
        }
        return false;
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index, int loadGroupIndex) throws IOException {
        if (loadGroupIndex == 0 && this._discriminator != null) {
            ++index;
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            if (field.getLoadGroupIndex() != loadGroupIndex) continue;
            index = field.generateLoad(out, rs, indexVar, index);
        }
        return index;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (this.getId() != null) {
            this.getId().generateSet(out, pstmt, index, value);
        }
    }

    @Override
    public Object getObject(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this.getHome().loadLazy(aConn, rs, index);
    }

    @Override
    public EntityItem findItem(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this.getHome().findItem(aConn, rs, index);
    }

    public Object getLoadObject(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this.getHome().loadFull(aConn, rs, index);
    }

    public void setGenerator(String name, IdGenerator gen) {
        this._idGenMap.put(name, gen);
    }

    public IdGenerator getGenerator(String name) {
        return this._idGenMap.get(name);
    }

    public long nextGeneratorId(AmberConnectionImpl aConn, String name) throws SQLException {
        return this._idGenMap.get(name).allocate(aConn);
    }

    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        this.getId().generateLoadFromObject(out, obj);
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateLoadFromObject(out, obj);
        }
    }

    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadGroup) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateCopyUpdateObject(out, dst, src, loadGroup);
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateCopyLoadObject(out, dst, src, loadGroup);
        }
    }

    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateCopyUpdateObject(out, dst, src, updateIndex);
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateCopyUpdateObject(out, dst, src, updateIndex);
        }
    }

    public String generateKeyLoadSelect(String id) {
        String select = this.getId().generateLoadSelect(id);
        if (this.getDiscriminator() != null) {
            if (select != null && !select.equals("")) {
                select = new CharBuffer().append(select).append(", ").toString();
            }
            select = new CharBuffer().append(select).append(this.getDiscriminator().getName()).toString();
        }
        return select;
    }

    public String generateFullLoadSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        String idSelect = this.getId().generateSelect(id);
        if (idSelect != null) {
            cb.append(idSelect);
        }
        String loadSelect = this.generateLoadSelect(id);
        if (!idSelect.equals("") && !loadSelect.equals("")) {
            cb.append(",");
        }
        cb.append(loadSelect);
        return cb.close();
    }

    public String generateLoadSelect(String id) {
        return this.generateLoadSelect(this.getTable(), id, 0);
    }

    public String generateLoadSelect(Table table, String id) {
        return this.generateLoadSelect(table, id, 0);
    }

    public String generateLoadSelect(Table table, String id, int loadGroup) {
        CharBuffer cb = CharBuffer.allocate();
        boolean hasSelect = false;
        if (loadGroup == 0 && this.getParentType() != null) {
            String parentSelect = this.getParentType().generateLoadSelect(table, id, loadGroup);
            cb.append(parentSelect);
            if (!parentSelect.equals("")) {
                hasSelect = true;
            }
        } else if (loadGroup == 0 && this.getDiscriminator() != null) {
            if (id != null) {
                cb.append(new CharBuffer().append(id).append(".").toString());
            }
            cb.append(this.getDiscriminator().getName());
            hasSelect = true;
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            String propSelect;
            AmberField field = fields.get(i);
            if (field.getLoadGroupIndex() != loadGroup || (propSelect = field.generateLoadSelect(table, id)) == null) continue;
            if (hasSelect) {
                cb.append(", ");
            }
            hasSelect = true;
            cb.append(propSelect);
        }
        if (cb.length() == 0) {
            return null;
        }
        return cb.close();
    }

    public String generateCreateSQL(Table table) {
        int i;
        CharBuffer sql = CharBuffer.allocate();
        sql.append(new CharBuffer().append("INSERT INTO ").append(table.getName()).append(" (").toString());
        boolean isFirst = true;
        ArrayList<String> idColumns = new ArrayList<String>();
        for (IdField field : this.getId().getKeys()) {
            for (Column key : field.getColumns()) {
                String name = table == key.getTable() ? key.getName() : table.getDependentIdLink().getSourceColumn(key).getName();
                idColumns.add(name);
                if (!isFirst) {
                    sql.append(", ");
                }
                isFirst = false;
                sql.append(name);
            }
        }
        if (table == this.getTable() && this.getDiscriminator() != null) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append(this.getDiscriminator().getName());
        }
        ArrayList<String> columns = new ArrayList<String>();
        this.generateInsertColumns(table, columns);
        for (String columnName : columns) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append(columnName);
        }
        sql.append(") VALUES (");
        isFirst = true;
        for (i = 0; i < idColumns.size(); ++i) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append("?");
        }
        if (table == this.getTable() && this.getDiscriminator() != null) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append(new CharBuffer().append("'").append(this.getDiscriminatorValue()).append("'").toString());
        }
        for (i = 0; i < columns.size(); ++i) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    protected void generateInsertColumns(Table table, ArrayList<String> columns) {
        if (this.getParentType() != null) {
            this.getParentType().generateInsertColumns(table, columns);
        }
        for (AmberField field : this.getFields()) {
            if (field.getTable() != table) continue;
            field.generateInsertColumns(columns);
        }
    }

    public void generateInsertSet(JavaWriter out, Table table, String pstmt, String query, String obj) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateInsertSet(out, table, pstmt, query, obj);
        }
        for (AmberField field : this.getFields()) {
            if (field.getTable() != table) continue;
            field.generateInsertSet(out, pstmt, query, obj);
        }
    }

    public String generateIdSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(this.getId().generateSelect(id));
        if (this._discriminator != null) {
            cb.append(", ");
            cb.append(this._discriminator.getName());
        }
        return cb.close();
    }

    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateInvalidateForeign(out);
        }
    }

    public void generateExpire(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateExpire(out);
        }
    }

    public JMethod getGetter(String name) {
        return EntityType.getGetter(this._beanClass, name);
    }

    public static JMethod getGetter(JClass cl, String name) {
        JMethod[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JClass[] param = methods[i].getParameterTypes();
            String methodName = methods[i].getName();
            if (!name.equals(methodName) || param.length != 0) continue;
            return methods[i];
        }
        if ((cl = cl.getSuperClass()) != null) {
            return EntityType.getGetter(cl, name);
        }
        return null;
    }

    public static JField getField(JClass cl, String name) {
        JField[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        if ((cl = cl.getSuperClass()) != null) {
            return EntityType.getField(cl, name);
        }
        return null;
    }

    public static JMethod getSetter(JClass cl, String name) {
        JMethod[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JClass[] param = methods[i].getParameterTypes();
            String methodName = methods[i].getName();
            if (!name.equals(methodName) || param.length != 1) continue;
            return methods[i];
        }
        if ((cl = cl.getSuperClass()) != null) {
            return EntityType.getSetter(cl, name);
        }
        return null;
    }

    public void generateUpdateSQLPrefix(CharBuffer sql) {
        sql.append(new CharBuffer().append("UPDATE ").append(this.getTable().getName()).append(" SET ").toString());
    }

    public boolean generateUpdateSQLComponent(CharBuffer sql, int group, long mask, boolean isFirst) {
        ArrayList<AmberField> fields = this.getFields();
        while (mask != 0L) {
            int i = 0;
            i = 0;
            while ((mask & 1L << i) == 0L) {
                ++i;
            }
            mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
            AmberField field = null;
            for (int j = 0; j < fields.size() && (field = fields.get(j)).getIndex() != i + group * 64; ++j) {
                field = null;
            }
            if (field == null) continue;
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            field.generateUpdate(sql);
        }
        return isFirst;
    }

    public void generateUpdateSQLSuffix(CharBuffer sql) {
        sql.append(" WHERE ");
        sql.append(this.getId().generateMatchArgWhere(null));
    }

    public String generateUpdateSQL(long mask) {
        if (mask == 0L) {
            return null;
        }
        CharBuffer sql = CharBuffer.allocate();
        sql.append(new CharBuffer().append("UPDATE ").append(this.getTable().getName()).append(" SET ").toString());
        boolean isFirst = true;
        ArrayList<AmberField> fields = this.getFields();
        while (mask != 0L) {
            int i = 0;
            i = 0;
            while ((mask & 1L << i) == 0L) {
                ++i;
            }
            mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
            AmberField field = null;
            for (int j = 0; j < fields.size() && (field = fields.get(j)).getIndex() != i; ++j) {
                field = null;
            }
            if (field == null) continue;
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            field.generateUpdate(sql);
        }
        if (isFirst) {
            return null;
        }
        sql.append(" WHERE ");
        sql.append(this.getId().generateMatchArgWhere(null));
        return sql.toString();
    }

    public void generatePreDelete(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generatePreDelete(out);
        }
    }

    public void generatePostDelete(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generatePostDelete(out);
        }
    }

    public void delete(AmberConnectionImpl aConn, Object key) throws SQLException {
        this.getHome().delete(aConn, key);
    }

    public void update(Entity entity) throws SQLException {
    }

    public AmberCompletion createManyToOneCompletion(String name, Entity source, Object newTarget) {
        AmberField field = this.getField(name);
        if (field instanceof EntityManyToOneField) {
            EntityManyToOneField manyToOne = (EntityManyToOneField)field;
            return this.getTable().getInvalidateCompletion();
        }
        throw new IllegalStateException();
    }

    public boolean isEJBProxy(String typeName) {
        return this.getBeanClass() != this.getProxyClass() && this.getProxyClass().getName().equals(typeName);
    }

    public String toString() {
        return new CharBuffer().append("EntityType[").append(this._beanClass.getName()).append("]").toString();
    }

    static {
        $assertionsDisabled = !EntityType._resin_compat_class_1().desiredAssertionStatus();
        log = Logger.getLogger(EntityType._resin_compat_class_1().getName());
        L = new L10N(EntityType._resin_compat_class_1());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.entity.Entity");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.amber.type.EntityType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

