/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ByteType
extends Type {
    private static final L10N L = new L10N(ByteType._resin_compat_class_0());
    private static final ByteType BYTE_TYPE = new ByteType();
    private static Class _resin_compat_class_0;

    private ByteType() {
    }

    public static ByteType create() {
        return BYTE_TYPE;
    }

    public String getName() {
        return "java.lang.Byte";
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(-6, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.ByteType.toByte(").append(rs).append(".getByte(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.TINYINT);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setByte(").append(index).append("++, ").append(value).append(".byteValue());").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.TINYINT);").toString());
    }

    public static Byte toByte(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Byte((byte)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        byte value = rs.getByte(index);
        return rs.wasNull() ? null : new Byte(value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.ByteType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

