/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigDecimalType
extends Type {
    private static final L10N L = new L10N(BigDecimalType._resin_compat_class_0());
    private int _scale = -1;
    private static Class _resin_compat_class_0;

    private BigDecimalType() {
    }

    public static BigDecimalType create() {
        return new BigDecimalType();
    }

    public String getName() {
        return "java.math.BigDecimal";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getBigDecimal(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.DECIMAL);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setBigDecimal(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setBigDecimal(index, (BigDecimal)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getBigDecimal(index);
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(2, length, precision, scale);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.BigDecimalType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

