/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.table;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkColumns {
    private static final L10N L;
    private static final Logger log;
    private static final int NO_CASCADE_DELETE = 0;
    private static final int SOURCE_CASCADE_DELETE = 1;
    private static final int TARGET_CASCADE_DELETE = 2;
    private Table _sourceTable;
    private Table _targetTable;
    private ArrayList<ForeignColumn> _columns;
    private int _cascadeDelete;
    private AmberCompletion _tableDeleteCompletion;
    private AmberCompletion _tableUpdateCompletion;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static Class _resin_compat_class_0;

    public LinkColumns(Table sourceTable, Table targetTable, ArrayList<ForeignColumn> columns) {
        this._sourceTable = sourceTable;
        this._targetTable = targetTable;
        this._columns = columns;
        this._tableDeleteCompletion = sourceTable.getDeleteCompletion();
        this._tableUpdateCompletion = sourceTable.getUpdateCompletion();
        this._sourceTable.addOutgoingLink(this);
        this._targetTable.addIncomingLink(this);
    }

    public void setSourceCascadeDelete(boolean isCascadeDelete) {
        if (isCascadeDelete) {
            if (!$assertionsDisabled && this._cascadeDelete == 2) {
                throw new AssertionError();
            }
            this._cascadeDelete = 1;
        } else if (this._cascadeDelete == 1) {
            this._cascadeDelete = 0;
        }
    }

    public void setTargetCascadeDelete(boolean isCascadeDelete) {
        if (isCascadeDelete) {
            if (!$assertionsDisabled && this._cascadeDelete == 1) {
                throw new AssertionError();
            }
            this._cascadeDelete = 2;
        } else if (this._cascadeDelete == 2) {
            this._cascadeDelete = 0;
        }
    }

    public boolean isSourceCascadeDelete() {
        return this._cascadeDelete == 1;
    }

    public boolean isTargetCascadeDelete() {
        return this._cascadeDelete == 2;
    }

    public Table getSourceTable() {
        return this._sourceTable;
    }

    public Table getTargetTable() {
        return this._targetTable;
    }

    public ArrayList<ForeignColumn> getColumns() {
        return this._columns;
    }

    public ForeignColumn getSourceColumn(Column targetKey) {
        for (int i = this._columns.size() - 1; i >= 0; --i) {
            ForeignColumn column = this._columns.get(i);
            if (column.getTargetColumn() != targetKey) continue;
            return column;
        }
        return null;
    }

    public String generateSelectSQL(String table) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._columns.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            if (table != null) {
                cb.append(table);
                cb.append(".");
            }
            cb.append(this._columns.get(i).getName());
        }
        return cb.toString();
    }

    public void generateInsert(ArrayList<String> columns) {
        for (int i = 0; i < this._columns.size(); ++i) {
            columns.add(this._columns.get(i).getName());
        }
    }

    public String generateUpdateSQL() {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._columns.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(new CharBuffer().append(this._columns.get(i).getName()).append("=?").toString());
        }
        return cb.toString();
    }

    public String generateMatchArgSQL(String table) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._columns.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            if (table != null) {
                cb.append(table);
                cb.append(".");
            }
            cb.append(this._columns.get(i).getName());
            cb.append("=?");
        }
        return cb.toString();
    }

    public String generateJoin(String sourceTable, String targetTable) {
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._columns.size(); ++i) {
            ForeignColumn column = this._columns.get(i);
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(sourceTable);
            cb.append('.');
            cb.append(column.getName());
            cb.append(" = ");
            cb.append(targetTable);
            cb.append('.');
            cb.append(column.getTargetColumn().getName());
        }
        cb.append(')');
        return cb.toString();
    }

    public String generateWhere(String sourceTable, String targetTable) {
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._columns.size(); ++i) {
            ForeignColumn column = this._columns.get(i);
            if (i != 0) {
                cb.append(" AND ");
            }
            if (!column.isNotNull()) {
                cb.append(sourceTable);
                cb.append('.');
                cb.append(column.getName());
                cb.append(" IS NOT NULL ");
            }
            cb.append(" AND ");
            cb.append(sourceTable);
            cb.append('.');
            cb.append(column.getName());
            cb.append(" = ");
            cb.append(targetTable);
            cb.append('.');
            cb.append(column.getTargetColumn().getName());
        }
        cb.append(')');
        return cb.toString();
    }

    public void beforeTargetDelete(AmberConnectionImpl aConn, Entity entity) throws SQLException {
        aConn.flush();
        String sourceTable = this._sourceTable.getName();
        if (!this.isSourceCascadeDelete()) {
            int i;
            CharBuffer cb = new CharBuffer();
            cb.append(new CharBuffer().append("UPDATE ").append(sourceTable).append(" SET ").toString());
            ArrayList<ForeignColumn> columns = this.getColumns();
            for (i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    cb.append(", ");
                }
                cb.append(new CharBuffer().append(columns.get(i).getName()).append("=NULL").toString());
            }
            cb.append(" WHERE ");
            for (i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    cb.append(" AND ");
                }
                cb.append(new CharBuffer().append(columns.get(i).getName()).append("=?").toString());
            }
            PreparedStatement pstmt = aConn.prepareStatement(cb.toString());
            entity.__caucho_setKey(pstmt, 1);
            pstmt.executeUpdate();
            aConn.addCompletion(this._sourceTable.getUpdateCompletion());
        } else if (this._sourceTable.isCascadeDelete()) {
            EntityType entityType = this._sourceTable.getType();
            CharBuffer cb = new CharBuffer();
            cb.append("SELECT ");
            cb.append(entityType.getId().generateSelect("o"));
            cb.append(new CharBuffer().append(" FROM ").append(sourceTable).append(" o").toString());
            cb.append(" WHERE ");
            ArrayList<ForeignColumn> columns = this.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    cb.append(" AND ");
                }
                cb.append(new CharBuffer().append(columns.get(i).getName()).append("=?").toString());
            }
            PreparedStatement pstmt = aConn.prepareStatement(cb.toString());
            entity.__caucho_setKey(pstmt, 1);
            ArrayList<Object> proxyList = new ArrayList<Object>();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                proxyList.add(entityType.getHome().loadLazy(aConn, rs, 1));
            }
            rs.close();
            for (Object e : proxyList) {
                entityType.getHome().getEntityFactory().delete(aConn, e);
            }
        } else {
            CharBuffer cb = new CharBuffer();
            cb.append(new CharBuffer().append("DELETE FROM ").append(sourceTable).append(" WHERE ").toString());
            ArrayList<ForeignColumn> columns = this.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    cb.append(" AND ");
                }
                cb.append(new CharBuffer().append(columns.get(i).getName()).append("=?").toString());
            }
            PreparedStatement pstmt = aConn.prepareStatement(cb.toString());
            entity.__caucho_setKey(pstmt, 1);
            pstmt.executeUpdate();
            aConn.addCompletion(this._sourceTable.getDeleteCompletion());
        }
        aConn.expire();
    }

    public void afterSourceDelete(AmberConnectionImpl aConn, Entity entity) throws SQLException {
    }

    static {
        $assertionsDisabled = !LinkColumns._resin_compat_class_0().desiredAssertionStatus();
        L = new L10N(LinkColumns._resin_compat_class_0());
        log = Log.open(LinkColumns._resin_compat_class_0());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.table.LinkColumns");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

