/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.table;

import com.caucho.amber.AmberManager;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class Column {
    private static final L10N L = new L10N(Column._resin_compat_class_0());
    private Table _table;
    private String _name;
    private String _configLocation;
    private Type _type;
    private boolean _isPrimaryKey;
    private String _sqlType;
    private boolean _isNotNull;
    private boolean _isUnique;
    private int _length;
    private int _precision;
    private int _scale;
    private String _generatorType;
    private String _generator;
    private String _fieldName;
    private static Class _resin_compat_class_0;

    Column(Table table, String name) {
        this._table = table;
        this._name = name;
    }

    Column(Table table, String name, Type type) {
        this._table = table;
        this._name = name;
        this._type = type;
    }

    public Table getTable() {
        return this._table;
    }

    public String getName() {
        return this._name;
    }

    public void setConfigLocation(String location) {
        this._configLocation = location;
    }

    public Type getType() {
        return this._type;
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this._isPrimaryKey = isPrimaryKey;
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void setGeneratorType(String type) {
        this._generatorType = type;
    }

    public String generateInsertName() {
        return this._name;
    }

    public void setSQLType(String sqlType) {
        this._sqlType = sqlType;
    }

    public String getSQLType() {
        return this._sqlType;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getLength() {
        return this._length;
    }

    public void setNotNull(boolean isNotNull) {
        this._isNotNull = isNotNull;
    }

    public boolean isNotNull() {
        return this._isNotNull;
    }

    public void setPrecision(int precision) {
        this._precision = precision;
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setScale(int scale) {
        this._scale = scale;
    }

    public int getScale() {
        return this._scale;
    }

    public void setUnique(boolean isUnique) {
        this._isUnique = isUnique;
    }

    public boolean isUnique() {
        return this._isUnique;
    }

    String generateCreateTableSQL(AmberManager manager) {
        CharBuffer cb = new CharBuffer();
        cb.append(new CharBuffer().append(this._name).append(" ").toString());
        String sqlType = this._sqlType;
        sqlType = this._sqlType != null ? this._sqlType : this._type.generateCreateColumnSQL(manager, this._length, this._precision, this._scale);
        if ("identity".equals(this._generatorType)) {
            cb.append(manager.getMetaData().createIdentitySQL(sqlType));
        } else {
            cb.append(sqlType);
        }
        if (this.isPrimaryKey()) {
            cb.append(" PRIMARY KEY");
        } else if (!"identity".equals(this._generatorType)) {
            if (this.isNotNull()) {
                cb.append(" NOT NULL");
            }
            if (this.isUnique()) {
                cb.append(" UNIQUE");
            }
        }
        return cb.toString();
    }

    void validateDatabase(AmberManager amberManager) throws ConfigException {
        try {
            DataSource ds = amberManager.getDataSource();
            Connection conn = ds.getConnection();
            try {
                Statement stmt = conn.createStatement();
                String sql = new CharBuffer().append("SELECT ").append(this.getName()).append(" FROM ").append(this._table.getName()).append(" WHERE 1=0").toString();
                try {
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                    return;
                }
                catch (SQLException e) {
                    throw this.error(L.l("'{0}' is not a valid database column in table '{1}'.  Either the table needs to be created or the create-database-tables attribute must be set.\n\n  {2}\n\n{3}", this.getName(), this.getTable().getName(), sql, e.toString()), e);
                }
            }
            finally {
                conn.close();
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public String generateSelect(String id) {
        return new CharBuffer().append(id).append(".").append(this._name).toString();
    }

    public String generateMatchArgWhere(String id) {
        if (id != null) {
            return new CharBuffer().append(id).append(".").append(this._name).append("=?").toString();
        }
        return new CharBuffer().append(this._name).append("=?").toString();
    }

    public String generateUpdateSet() {
        return new CharBuffer().append(this._name).append("=?").toString();
    }

    public String generateUpdateSetNull() {
        return new CharBuffer().append(this._name).append("=null").toString();
    }

    public void generatePrologue(JavaWriter out) throws IOException {
    }

    public String getFieldName() {
        return new CharBuffer().append("__amber_").append(this.getName()).toString();
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (value != null) {
            this._type.generateSet(out, pstmt, index, value);
        } else {
            this._type.generateSetNull(out, pstmt, index);
        }
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this._type.generateLoad(out, rs, indexVar, index);
    }

    public Object toObjectKey(long value) {
        return this.getType().toObject(value);
    }

    protected ConfigException error(String msg, Throwable e) {
        if (this._configLocation != null) {
            return new LineConfigException(new CharBuffer().append(this._configLocation).append(msg).toString(), e);
        }
        if (this._table.getLocation() != null) {
            return new LineConfigException(new CharBuffer().append(this._table.getLocation()).append(msg).toString(), e);
        }
        return new ConfigException(msg, e);
    }

    public String toString() {
        return new CharBuffer().append("Column[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.table.Column");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

