/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberManager;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.AndExpr;
import com.caucho.amber.query.ArgExpr;
import com.caucho.amber.query.BetweenExpr;
import com.caucho.amber.query.BinaryExpr;
import com.caucho.amber.query.CollectionIdExpr;
import com.caucho.amber.query.ConcatExpr;
import com.caucho.amber.query.DeleteQuery;
import com.caucho.amber.query.EmptyExpr;
import com.caucho.amber.query.ExistsExpr;
import com.caucho.amber.query.FromIdSchemaExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.FunExpr;
import com.caucho.amber.query.IdExpr;
import com.caucho.amber.query.InExpr;
import com.caucho.amber.query.LikeExpr;
import com.caucho.amber.query.LiteralExpr;
import com.caucho.amber.query.LoadEntityExpr;
import com.caucho.amber.query.MemberExpr;
import com.caucho.amber.query.NullExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.OrExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.SchemaExpr;
import com.caucho.amber.query.SelectQuery;
import com.caucho.amber.query.SubSelectExpr;
import com.caucho.amber.query.TableIdExpr;
import com.caucho.amber.query.UnaryExpr;
import com.caucho.amber.query.UpdateQuery;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser {
    static final Logger log = Log.open(QueryParser._resin_compat_class_1());
    static final L10N L = new L10N(QueryParser._resin_compat_class_1());
    static final int IDENTIFIER = 128;
    static final int INTEGER = 129;
    static final int LONG = 130;
    static final int DOUBLE = 131;
    static final int STRING = 132;
    static final int TRUE = 133;
    static final int FALSE = 134;
    static final int UNKNOWN = 135;
    static final int MEMBER = 136;
    static final int OF = 137;
    static final int EMPTY = 138;
    static final int NULL = 139;
    static final int FROM = 140;
    static final int IN = 141;
    static final int SELECT = 142;
    static final int UPDATE = 143;
    static final int DELETE = 144;
    static final int DISTINCT = 145;
    static final int WHERE = 146;
    static final int AS = 147;
    static final int SET = 148;
    static final int ORDER = 149;
    static final int GROUP = 150;
    static final int BY = 151;
    static final int ASC = 152;
    static final int DESC = 153;
    static final int LIMIT = 154;
    static final int OFFSET = 155;
    static final int BETWEEN = 156;
    static final int LIKE = 157;
    static final int ESCAPE = 158;
    static final int IS = 159;
    static final int CONCAT = 160;
    static final int EQ = 161;
    static final int NE = 162;
    static final int LT = 163;
    static final int LE = 164;
    static final int GT = 165;
    static final int GE = 166;
    static final int AND = 167;
    static final int OR = 168;
    static final int NOT = 169;
    static final int EXTERNAL_DOT = 170;
    static final int ARG = 171;
    static final int THIS = 172;
    static final int NOT_NULL = 173;
    private static IntMap _reserved = new IntMap();
    private AmberManager _amberManager;
    private String _sql;
    private boolean _isLazyResult;
    private AbstractQuery _query;
    private HashMap<PathExpr, PathExpr> _pathMap = new HashMap();
    private int _parseIndex;
    private int _token;
    private int _unique;
    private int _parameterCount;
    private String _lexeme;
    private ArrayList<ArgExpr> _argList = new ArrayList();
    private int _sqlArgCount;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public QueryParser(String query) {
        this._sql = query;
    }

    public void setAmberManager(AmberManager amberManager) {
        this._amberManager = amberManager;
    }

    public void setLazyResult(boolean isLazy) {
        this._isLazyResult = isLazy;
    }

    public String getQuery() {
        return this._sql;
    }

    public AbstractQuery getSelectQuery() {
        return this._query;
    }

    private void init() {
        this._parseIndex = 0;
        this._unique = 0;
        this._token = -1;
    }

    int generateSQLArg() {
        return this._sqlArgCount++;
    }

    public AbstractQuery parse() throws AmberException {
        this.init();
        int token = this.scanToken();
        if (token == 143) {
            return this.parseUpdate();
        }
        if (token == 144) {
            return this.parseDelete();
        }
        this._token = token;
        return this.parseSelect();
    }

    private SelectQuery parseSelect() throws QueryParseException {
        AmberExpr expr;
        ArrayList<FromItem> fromList;
        int token;
        int oldParseIndex = this._parseIndex;
        int oldToken = this._token;
        SelectQuery query = new SelectQuery(this._sql);
        query.setParentQuery(this._query);
        this._query = query;
        while ((token = this.scanToken()) >= 0 && token != 140) {
        }
        if (token != 140) {
            throw this.error(L.l("expected FROM at {0}", this.tokenName(token)));
        }
        this._token = token;
        do {
            this.scanToken();
            FromItem from = this.parseFrom();
        } while ((token = this.peekToken()) == 44);
        int fromParseIndex = this._parseIndex;
        int fromToken = this._token;
        this._parseIndex = oldParseIndex;
        this._token = oldToken;
        ArrayList<AmberExpr> resultList = new ArrayList<AmberExpr>();
        if (this.peekToken() == 142) {
            this.scanToken();
            if (this.peekToken() == 145) {
                this.scanToken();
                query.setDistinct(true);
            }
            do {
                AmberExpr expr2 = this.parseExpr();
                expr2 = expr2.bindSelect(this);
                if (!this._isLazyResult && expr2 instanceof PathExpr) {
                    PathExpr pathExpr = (PathExpr)expr2;
                    expr2 = new LoadEntityExpr(pathExpr);
                    expr2 = expr2.bindSelect(this);
                }
                resultList.add(expr2);
            } while ((token = this.scanToken()) == 44);
            this._token = token;
        }
        if (this.peekToken() != 140) {
            throw this.error(L.l("expected FROM at {0}", this.tokenName(token)));
        }
        if (resultList.size() == 0 && (fromList = this._query.getFromList()).size() > 0) {
            FromItem fromItem = fromList.get(0);
            expr = fromItem.getIdExpr();
            if (!this._isLazyResult && expr instanceof PathExpr) {
                PathExpr pathExpr = (PathExpr)expr;
                expr = new LoadEntityExpr(pathExpr);
                expr = expr.bindSelect(this);
            }
            resultList.add(expr);
        }
        query.setResultList(resultList);
        this._parseIndex = fromParseIndex;
        this._token = fromToken;
        token = this.peekToken();
        if (token == 146) {
            this.scanToken();
            query.setWhere(this.parseExpr().createBoolean().bindSelect(this));
        }
        if ((token = this.peekToken()) == 149) {
            this.scanToken();
            if (this.peekToken() == 151) {
                this.scanToken();
            }
            ArrayList<AmberExpr> orderList = new ArrayList<AmberExpr>();
            ArrayList<Boolean> ascList = new ArrayList<Boolean>();
            while (true) {
                expr = this.parseExpr();
                expr = expr.bindSelect(this);
                orderList.add(expr);
                if (this.peekToken() == 153) {
                    this.scanToken();
                    ascList.add(Boolean.FALSE);
                } else if (this.peekToken() == 152) {
                    this.scanToken();
                    ascList.add(Boolean.TRUE);
                } else {
                    ascList.add(Boolean.TRUE);
                }
                if (this.peekToken() != 44) break;
                this.scanToken();
            }
            query.setOrderList(orderList, ascList);
        }
        if ((token = this.peekToken()) == 150) {
            this.scanToken();
            if (this.peekToken() == 151) {
                this.scanToken();
            }
            ArrayList<AmberExpr> groupList = new ArrayList<AmberExpr>();
            while (true) {
                groupList.add(this.parseExpr());
                if (this.peekToken() != 44) break;
                this.scanToken();
            }
            query.setGroupList(groupList);
        }
        if ((token = this.peekToken()) > 0) {
            throw this.error(L.l("expected end of query at {0}", this.tokenName(token)));
        }
        query.setArgList(this._argList.toArray(new ArgExpr[this._argList.size()]));
        try {
            query.init();
        }
        catch (SQLException e) {
            throw new QueryParseException(e);
        }
        return query;
    }

    private AbstractQuery parseUpdate() throws QueryParseException {
        UpdateQuery query = new UpdateQuery(this._sql);
        this._query = query;
        FromItem fromItem = this.parseFrom();
        int token = this.scanToken();
        if (token != 148) {
            throw this.error(L.l("expected 'SET' at {0}", this.tokenName(token)));
        }
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<AmberExpr> values = new ArrayList<AmberExpr>();
        this.parseSetValues(fields, values);
        query.setFieldList(fields);
        query.setValueList(values);
        token = this.scanToken();
        if (token == 146) {
            AmberExpr where = this.parseExpr();
            where = where.bindSelect(this);
            query.setWhere(where);
            token = this.scanToken();
        }
        if (token >= 0) {
            throw this.error(L.l("'{0}' not expected at end of query.", this.tokenName(token)));
        }
        query.init();
        query.setArgList(this._argList.toArray(new ArgExpr[this._argList.size()]));
        return query;
    }

    private AbstractQuery parseDelete() throws QueryParseException {
        DeleteQuery query = new DeleteQuery(this._sql);
        this._query = query;
        int token = this.peekToken();
        if (token == 140) {
            this.scanToken();
        }
        FromItem fromItem = this.parseFrom();
        token = this.scanToken();
        if (token == 146) {
            AmberExpr where = this.parseExpr();
            where = where.bindSelect(this);
            query.setWhere(where);
            token = this.scanToken();
        }
        if (token >= 0) {
            throw this.error(L.l("'{0}' not expected at end of query.", this.tokenName(token)));
        }
        query.init();
        query.setArgList(this._argList.toArray(new ArgExpr[this._argList.size()]));
        return query;
    }

    private void parseSetValues(ArrayList<String> fields, ArrayList<AmberExpr> values) throws QueryParseException {
        int token;
        do {
            String field = this.parseIdentifier();
            token = this.scanToken();
            if (token != 161) {
                throw this.error(L.l("expected '=' at {0}", this.tokenName(token)));
            }
            AmberExpr expr = this.parseExpr();
            fields.add(field);
            values.add(expr);
        } while ((token = this.scanToken()) == 44);
        this._token = token;
    }

    private FromItem parseFrom() throws QueryParseException {
        String id;
        SchemaExpr schema = this.parseSchema();
        int token = this.peekToken();
        if (token == 147) {
            this.scanToken();
            token = this.peekToken();
            id = this.parseIdentifier();
        } else {
            id = token == 128 ? this.parseIdentifier() : schema.getTailName();
        }
        return schema.addFromItem(this, id);
    }

    FromItem addFromItem(Table table) {
        return this.addFromItem(table, this.createTableName());
    }

    String createTableName() {
        return new CharBuffer().append("caucho").append(this._unique++).toString();
    }

    FromItem addFromItem(Table table, String id) {
        if (id == null) {
            id = this.createTableName();
        }
        return this._query.createFromItem(table, id);
    }

    FromItem createDependentFromItem(FromItem item, LinkColumns link) {
        return this._query.createDependentFromItem(item, link, this.createTableName());
    }

    void addLink(AmberExpr expr) {
        throw new IllegalStateException();
    }

    PathExpr addPath(PathExpr path) {
        PathExpr oldPath = this._pathMap.get(path);
        if (oldPath != null) {
            return oldPath;
        }
        this._pathMap.put(path, path);
        return path;
    }

    void addArg(ArgExpr arg) {
        this._argList.add(arg);
    }

    private SchemaExpr parseSchema() throws QueryParseException {
        String segment;
        IdExpr id;
        AmberEntityHome home;
        boolean isIn;
        int token = this.peekToken();
        boolean bl = isIn = token == 141;
        if (isIn) {
            this.scanToken();
            token = this.scanToken();
            if (token != 40) {
                throw this.error(L.l("expected '(' at '{0}'", this.tokenName(token)));
            }
        }
        String name = this.parseIdentifier();
        SchemaExpr schema = null;
        if (!isIn && (home = this._amberManager.getHomeBySchema(name)) != null) {
            schema = new TableIdExpr(home.getEntityType(), name);
        }
        if (schema == null && (id = this.getIdentifier(name)) != null) {
            schema = new FromIdSchemaExpr(id);
        }
        if (!isIn && schema == null) {
            while (this.peekToken() == 46) {
                this.scanToken();
                segment = this.parseIdentifier();
                AmberEntityHome home2 = this._amberManager.getHomeBySchema(name = new CharBuffer().append(name).append('.').append(segment).toString());
                if (home2 == null) continue;
                schema = new TableIdExpr(home2.getEntityType(), name);
                break;
            }
        }
        if (schema == null) {
            throw this.error(L.l("'{0}' is an unknown entity.", name));
        }
        while (this.peekToken() == 46) {
            this.scanToken();
            segment = this.parseIdentifier();
            schema = schema.createField(this, segment);
        }
        if (isIn && (token = this.scanToken()) != 41) {
            throw this.error(L.l("expected ')' at '{0}'", this.tokenName(token)));
        }
        return schema;
    }

    private AmberExpr parseExpr() throws QueryParseException {
        if (this.peekToken() == 142) {
            SelectQuery select = this.parseSelect();
            return new SubSelectExpr(select);
        }
        AmberExpr expr = this.parseOrExpr();
        return expr;
    }

    private AmberExpr parseOrExpr() throws QueryParseException {
        AmberExpr expr = this.parseAndExpr();
        OrExpr orExpr = null;
        while (this.peekToken() == 168) {
            this.scanToken();
            if (orExpr == null) {
                orExpr = new OrExpr();
                orExpr.add(expr);
            }
            orExpr.add(this.parseAndExpr());
        }
        return orExpr == null ? expr : orExpr;
    }

    private AmberExpr parseAndExpr() throws QueryParseException {
        AmberExpr expr = this.parseNotExpr();
        AndExpr andExpr = null;
        while (this.peekToken() == 167) {
            this.scanToken();
            if (andExpr == null) {
                andExpr = new AndExpr();
                andExpr.add(expr);
            }
            andExpr.add(this.parseNotExpr());
        }
        return andExpr == null ? expr : andExpr;
    }

    private AmberExpr parseNotExpr() throws QueryParseException {
        if (this.peekToken() == 169) {
            this.scanToken();
            return new UnaryExpr(169, this.parseCmpExpr());
        }
        return this.parseCmpExpr();
    }

    private AmberExpr parseCmpExpr() throws QueryParseException {
        AmberExpr expr = this.parseConcatExpr();
        int token = this.peekToken();
        boolean isNot = false;
        if (token == 169) {
            this.scanToken();
            isNot = true;
            token = this.peekToken();
            if (token != 156 && token != 157 && token != 141) {
                throw this.error(L.l("'NOT' is not expected here."));
            }
        }
        if (token >= 161 && token <= 166) {
            this.scanToken();
            return this.parseIs(new BinaryExpr(token, expr, this.parseConcatExpr()));
        }
        if (token == 156) {
            this.scanToken();
            AmberExpr min = this.parseConcatExpr();
            token = this.scanToken();
            if (token != 167) {
                throw this.error(L.l("Expected 'AND' at {0}", this.tokenName(token)));
            }
            AmberExpr max = this.parseConcatExpr();
            return new BetweenExpr(expr, min, max, isNot);
        }
        if (token == 157) {
            this.scanToken();
            AmberExpr pattern = this.parseConcatExpr();
            String escape = null;
            if (this.peekToken() == 158) {
                this.scanToken();
                token = this.scanToken();
                if (token != 132) {
                    throw this.error(L.l("Expected string at {0}", this.tokenName(token)));
                }
                escape = this._lexeme.toString();
            }
            return this.parseIs(new LikeExpr(expr, pattern, escape, isNot));
        }
        if (token == 141) {
            this.scanToken();
            token = this.scanToken();
            if (token != 40) {
                throw this.error(L.l("Expected '(' after IN at {0}", this.tokenName(token)));
            }
            ArrayList<AmberExpr> args = new ArrayList<AmberExpr>();
            while ((token = this.peekToken()) > 0 && token != 41) {
                AmberExpr arg = this.parseExpr();
                args.add(arg);
                token = this.peekToken();
                if (token != 44) continue;
                this.scanToken();
                token = this.peekToken();
            }
            if (this.peekToken() != 41) {
                throw this.error(L.l("Expected ')' after IN at {0}", this.tokenName(token)));
            }
            this.scanToken();
            return new InExpr(expr, args, isNot);
        }
        if (token == 136) {
            this.scanToken();
            token = this.peekToken();
            if (token == 137) {
                token = this.scanToken();
            }
            AmberExpr collection = this.parseExpr();
            if (!(expr instanceof PathExpr)) {
                throw this.error(L.l("MEMBER OF requires an entity-valued item."));
            }
            if (!(collection instanceof OneToManyExpr) && !(collection instanceof CollectionIdExpr)) {
                throw this.error(L.l("MEMBER OF requires an entity-valued collection at '{0}'.", collection.getClass().getName()));
            }
            return this.parseIs(MemberExpr.create(this, (PathExpr)expr, collection, isNot));
        }
        return this.parseIs(expr);
    }

    private AmberExpr parseIs(AmberExpr expr) throws QueryParseException {
        int token = this.peekToken();
        if (token != 159) {
            return expr;
        }
        this.scanToken();
        boolean isNot = false;
        token = this.scanToken();
        if (token == 169) {
            isNot = true;
            token = this.scanToken();
        }
        if (token == 139) {
            if (isNot) {
                return new UnaryExpr(173, expr);
            }
            return new UnaryExpr(139, expr);
        }
        if (token == 138) {
            expr = new EmptyExpr(expr);
            if (!isNot) {
                expr = new UnaryExpr(169, expr);
            }
            return expr;
        }
        throw this.error(L.l("expected NULL at '{0}'", this.tokenName(token)));
    }

    private AmberExpr parseConcatExpr() throws QueryParseException {
        AmberExpr expr = this.parseAddExpr();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 160: {
                    this.scanToken();
                    expr = new ConcatExpr(expr, this.parseAddExpr());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private AmberExpr parseAddExpr() throws QueryParseException {
        AmberExpr expr = this.parseMulExpr();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 43: 
                case 45: {
                    this.scanToken();
                    expr = new BinaryExpr(token, expr, this.parseMulExpr());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private AmberExpr parseMulExpr() throws QueryParseException {
        AmberExpr expr = this.parseTerm();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 42: 
                case 47: {
                    this.scanToken();
                    expr = new BinaryExpr(token, expr, this.parseTerm());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private AmberExpr parseTerm() throws QueryParseException {
        int token = this.peekToken();
        switch (token) {
            case 43: 
            case 45: 
            case 169: {
                this.scanToken();
                return new UnaryExpr(token, this.parseTerm());
            }
        }
        return this.parseSimpleTerm();
    }

    private AmberExpr parseSimpleTerm() throws QueryParseException {
        int token = this.scanToken();
        switch (token) {
            case 128: {
                String name = this._lexeme.toString();
                if (this.peekToken() != 40) {
                    IdExpr tableExpr = this.getIdentifier(name);
                    if (tableExpr != null) {
                        return this.parsePath(tableExpr);
                    }
                    FromItem fromItem = this._query.getFromList().get(0);
                    tableExpr = fromItem.getIdExpr();
                    AmberExpr next = tableExpr.createField(this, name);
                    if (next instanceof PathExpr) {
                        return this.addPath((PathExpr)next);
                    }
                    if (next != null) {
                        return next;
                    }
                    throw this.error(L.l("'{0}' is an unknown table or column", name));
                }
                if (name.equalsIgnoreCase("exists")) {
                    this.scanToken();
                    if (this.peekToken() != 142 && this.peekToken() != 140) {
                        throw this.error(L.l("EXISTS requires '(SELECT'"));
                    }
                    SelectQuery select = this.parseSelect();
                    if (this.peekToken() != 41) {
                        throw this.error(L.l("EXISTS requires ')'"));
                    }
                    this.scanToken();
                    return new ExistsExpr(select);
                }
                return this.parseFunction(name);
            }
            case 134: {
                return new LiteralExpr(this._lexeme, Boolean.TYPE);
            }
            case 133: {
                return new LiteralExpr(this._lexeme, Boolean.TYPE);
            }
            case 139: {
                return new NullExpr();
            }
            case 129: {
                return new LiteralExpr(this._lexeme, Integer.TYPE);
            }
            case 130: {
                return new LiteralExpr(this._lexeme, Long.TYPE);
            }
            case 131: {
                return new LiteralExpr(this._lexeme, Double.TYPE);
            }
            case 132: {
                return new LiteralExpr(this._lexeme, QueryParser._resin_compat_class_0());
            }
            case 171: {
                ArgExpr arg = new ArgExpr(this, Integer.parseInt(this._lexeme));
                return arg;
            }
            case 40: {
                AmberExpr expr = this.parseExpr();
                token = this.scanToken();
                if (token != 41) {
                    throw this.error(L.l("expected `)' at {0}", this.tokenName(token)));
                }
                return expr;
            }
        }
        throw this.error(L.l("expected term at {0}", this.tokenName(token)));
    }

    private AmberExpr parsePath(PathExpr path) throws QueryParseException {
        while (this.peekToken() == 46) {
            this.scanToken();
            String field = this.parseIdentifier();
            AmberExpr next = path.createField(this, field);
            if (next == null) {
                throw this.error(L.l("'{0}' does not have a field '{1}'", (Object)path, field));
            }
            if (!(next instanceof PathExpr)) {
                return next;
            }
            PathExpr nextPath = this.addPath((PathExpr)next);
            if (this.peekToken() == 91) {
                this.scanToken();
                AmberExpr index = this.parseExpr();
                next = nextPath.createArray(index);
                if (next == null) {
                    throw this.error(L.l("'{0}' does not have a map field '{1}'", (Object)path, field));
                }
                if (this.peekToken() != 93) {
                    throw this.error(L.l("expected ']' at '{0}'", this.tokenName(this.peekToken())));
                }
                this.scanToken();
            }
            if (next instanceof PathExpr) {
                path = this.addPath((PathExpr)next);
                continue;
            }
            return next;
        }
        return path;
    }

    private AmberExpr parseFunction(String id) throws QueryParseException {
        this.scanToken();
        ArrayList<AmberExpr> args = new ArrayList<AmberExpr>();
        while (this.peekToken() != 41) {
            AmberExpr arg = this.parseExpr();
            args.add(arg);
            if (this.peekToken() != 44) break;
            this.scanToken();
        }
        if (this.peekToken() != 41) {
            throw this.error(L.l("expected ')' at '{0}'", this.tokenName(this.scanToken())));
        }
        this.scanToken();
        return FunExpr.create(id, args);
    }

    private IdExpr getIdentifier(String name) throws QueryParseException {
        for (AbstractQuery query = this._query; query != null; query = query.getParentQuery()) {
            ArrayList<FromItem> fromList = query.getFromList();
            for (int i = 0; i < fromList.size(); ++i) {
                FromItem from = fromList.get(i);
                if (!from.getName().equals(name)) continue;
                return from.getIdExpr();
            }
        }
        return null;
    }

    private String parseIdentifier() throws QueryParseException {
        int token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at `{0}'", this.tokenName(token)));
        }
        return this._lexeme;
    }

    private int peekToken() throws QueryParseException {
        if (this._token > 0) {
            return this._token;
        }
        this._token = this.scanToken();
        return this._token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanToken() throws QueryParseException {
        if (this._token > 0) {
            int value = this._token;
            this._token = -1;
            return value;
        }
        int sign = 1;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        switch (ch) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 91: 
            case 93: {
                return ch;
            }
            case 61: {
                ch = this.read();
                if (ch == 62) {
                    return 170;
                }
                this.unread(ch);
                return 161;
            }
            case 33: {
                ch = this.read();
                if (ch == 61) {
                    return 162;
                }
                this.unread(ch);
                return 33;
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 164;
                }
                if (ch == 62) {
                    return 162;
                }
                this.unread(ch);
                return 163;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 166;
                }
                this.unread(ch);
                return 165;
            }
            case 63: {
                CharBuffer cb = CharBuffer.allocate();
                int index = 0;
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    index = 10 * index + ch - 48;
                    ch = this.read();
                }
                this.unread(ch);
                this._lexeme = cb.close();
                if (this._lexeme.length() == 0) {
                    this._lexeme = String.valueOf(++this._parameterCount);
                    return 171;
                }
                if (index > 0) return 171;
                throw this.error(L.l("`{0}' must refer to a positive argument", new CharBuffer().append("?").append(this._lexeme).toString()));
            }
            case 124: {
                ch = this.read();
                if (ch != 124) throw this.error(L.l("unexpected char at {0}", String.valueOf((char)ch)));
                return 160;
            }
            case 64: {
                ch = this.read();
                if (ch == 64) return this.scanToken();
                throw this.error(L.l("`@' expected at {0}", this.charName(ch)));
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            CharBuffer cb = CharBuffer.allocate();
            while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                cb.append((char)ch);
                ch = this.read();
            }
            this.unread(ch);
            this._lexeme = cb.close();
            String lower = this._lexeme.toLowerCase();
            int token = _reserved.get(lower);
            if (token <= 0) return 128;
            return token;
        }
        if (ch >= 48 && ch <= 57) {
            CharBuffer cb = CharBuffer.allocate();
            int type = 129;
            if (sign < 0) {
                cb.append('-');
            }
            while (ch >= 48 && ch <= 57) {
                cb.append((char)ch);
                ch = this.read();
            }
            if (ch == 46) {
                type = 131;
                cb.append('.');
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 101 || ch == 69) {
                type = 131;
                cb.append('e');
                ch = this.read();
                if (ch == 43 || ch == 45) {
                    cb.append((char)ch);
                    ch = this.read();
                }
                if (ch < 48) throw this.error(L.l("exponent needs digits at {0}", this.charName(ch)));
                if (ch > 57) {
                    throw this.error(L.l("exponent needs digits at {0}", this.charName(ch)));
                }
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 70 || ch == 68) {
                type = 131;
            } else if (ch == 76) {
                type = 130;
            } else {
                this.unread(ch);
            }
            this._lexeme = cb.close();
            return type;
        }
        if (ch != 39) throw this.error(L.l("unexpected char at {0}", new CharBuffer().append("").append((char)ch).toString()));
        CharBuffer cb = CharBuffer.allocate();
        cb.append("'");
        ch = this.read();
        while (ch >= 0) {
            block38: {
                if (ch == 39) {
                    ch = this.read();
                    if (ch == 39) {
                        cb.append("''");
                        break block38;
                    } else {
                        this.unread(ch);
                        break;
                    }
                }
                cb.append((char)ch);
            }
            ch = this.read();
        }
        cb.append("'");
        this._lexeme = cb.close();
        return 132;
    }

    private int read() {
        if (this._parseIndex < this._sql.length()) {
            return this._sql.charAt(this._parseIndex++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._parseIndex;
        }
    }

    public QueryParseException error(String msg) {
        msg = new CharBuffer().append(msg).append("\nin \"").append(this._sql).append("\"").toString();
        return new QueryParseException(msg);
    }

    private String charName(int ch) {
        if (ch < 0) {
            return L.l("end of query");
        }
        return String.valueOf((char)ch);
    }

    private String tokenName(int token) {
        switch (token) {
            case 147: {
                return "AS";
            }
            case 140: {
                return "FROM";
            }
            case 141: {
                return "IN";
            }
            case 142: {
                return "SELECT";
            }
            case 146: {
                return "WHERE";
            }
            case 168: {
                return "OR";
            }
            case 167: {
                return "AND";
            }
            case 169: {
                return "NOT";
            }
            case 156: {
                return "BETWEEN";
            }
            case 172: {
                return "THIS";
            }
            case 133: {
                return "FALSE";
            }
            case 138: {
                return "EMPTY";
            }
            case 136: {
                return "MEMBER";
            }
            case 137: {
                return "OF";
            }
            case 139: {
                return "NULL";
            }
            case 149: {
                return "ORDER";
            }
            case 151: {
                return "BY";
            }
            case 152: {
                return "ASC";
            }
            case 153: {
                return "DESC";
            }
            case 154: {
                return "LIMIT";
            }
            case 170: {
                return "=>";
            }
            case -1: {
                return L.l("end of query");
            }
        }
        if (token < 128) {
            return new CharBuffer().append("'").append(String.valueOf((char)token)).append("'").toString();
        }
        return new CharBuffer().append("'").append(this._lexeme).append("'").toString();
    }

    public String toString() {
        return "QueryParser[]";
    }

    static {
        _reserved.put("as", 147);
        _reserved.put("from", 140);
        _reserved.put("in", 141);
        _reserved.put("select", 142);
        _reserved.put("update", 143);
        _reserved.put("delete", 144);
        _reserved.put("set", 148);
        _reserved.put("distinct", 145);
        _reserved.put("where", 146);
        _reserved.put("order", 149);
        _reserved.put("group", 150);
        _reserved.put("by", 151);
        _reserved.put("asc", 152);
        _reserved.put("desc", 153);
        _reserved.put("limit", 154);
        _reserved.put("offset", 155);
        _reserved.put("or", 168);
        _reserved.put("and", 167);
        _reserved.put("not", 169);
        _reserved.put("between", 156);
        _reserved.put("like", 157);
        _reserved.put("escape", 158);
        _reserved.put("is", 159);
        _reserved.put("this", 172);
        _reserved.put("true", 133);
        _reserved.put("false", 134);
        _reserved.put("unknown", 135);
        _reserved.put("empty", 138);
        _reserved.put("member", 136);
        _reserved.put("of", 137);
        _reserved.put("null", 139);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.amber.query.QueryParser");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

