/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractPathExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.OneToManyJoinExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;

public class OneToManyExpr
extends AbstractPathExpr {
    private PathExpr _parent;
    private LinkColumns _linkColumns;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public OneToManyExpr(QueryParser parser, PathExpr parent, LinkColumns linkColumns) {
        this._parent = parent;
        this._linkColumns = linkColumns;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    public Type getType() {
        return this._linkColumns.getSourceTable().getType();
    }

    public EntityType getTargetType() {
        return (EntityType)this.getType();
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return from == this._childFromItem || type == 1 && this._parent.usesFrom(from, type);
    }

    PathExpr getParent() {
        return this._parent;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        return this.bindSelect(parser, null);
    }

    public PathExpr bindSelect(QueryParser parser, String id) {
        if (this._fromItem != null) {
            return this;
        }
        this._fromItem = this._parent.bindSubPath(parser);
        Table sourceTable = this._linkColumns.getSourceTable();
        this._childFromItem = parser.addFromItem(sourceTable, id);
        OneToManyJoinExpr joinExpr = new OneToManyJoinExpr(this._linkColumns, this._childFromItem, this._fromItem);
        this._childFromItem.setJoinExpr(joinExpr);
        this._childFromItem.setCollectionExpr(this);
        return this;
    }

    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    public FromItem bindSubPath(QueryParser parser) {
        if (this._childFromItem == null) {
            this.bindSelect(parser, null);
        }
        return this._childFromItem;
    }

    public Table getTable() {
        return this._fromItem.getTable();
    }

    public void generateWhere(CharBuffer cb) {
        throw new IllegalStateException(this.getClass().getName());
    }

    public void generateSelect(CharBuffer cb) {
        String id = this._childFromItem.getName();
        cb.append(this._linkColumns.generateSelectSQL(id));
    }

    public String toString() {
        return new CharBuffer().append("OneToManyExpr[").append(this._parent).append(",").append(this._linkColumns).append("]").toString();
    }
}

