/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ColumnExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.IdExpr;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.KeyColumnExpr;
import com.caucho.amber.query.OneToManyJoinExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.util.CharBuffer;

public class ManyToOneJoinExpr
extends JoinExpr {
    private LinkColumns _linkColumns;
    private FromItem _sourceFromItem;
    private FromItem _targetFromItem;

    ManyToOneJoinExpr(LinkColumns link, FromItem source, FromItem target) {
        this._linkColumns = link;
        this._sourceFromItem = source;
        this._targetFromItem = target;
        if (source == null || target == null) {
            throw new NullPointerException();
        }
    }

    public boolean isBoolean() {
        return true;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    public boolean bindToFromItem() {
        if (this._targetFromItem.getJoinExpr() == null || this._targetFromItem.getJoinExpr().equals(this)) {
            this._targetFromItem.setJoinExpr(this);
            return true;
        }
        if (this._sourceFromItem.getJoinExpr() == null) {
            this._sourceFromItem.setJoinExpr(new OneToManyJoinExpr(this._linkColumns, this._sourceFromItem, this._targetFromItem));
            return true;
        }
        return false;
    }

    FromItem getJoinTarget() {
        return this._targetFromItem;
    }

    FromItem getJoinParent() {
        return this._sourceFromItem;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return from == this._targetFromItem || from == this._sourceFromItem;
    }

    public AmberExpr replace(KeyColumnExpr id) {
        PathExpr parent = id.getParent();
        if (parent.getChildFromItem() != this._targetFromItem) {
            return id;
        }
        ForeignColumn sourceColumn = this._linkColumns.getSourceColumn(id.getColumn());
        if (sourceColumn == null) {
            throw new IllegalStateException(id.getColumn().getName());
        }
        return new ColumnExpr(this._sourceFromItem.getIdExpr(), sourceColumn);
    }

    public AmberExpr replace(IdExpr id) {
        return id;
    }

    public void generateWhere(CharBuffer cb) {
        cb.append(this._linkColumns.generateWhere(this._sourceFromItem.getName(), this._targetFromItem.getName()));
    }

    public void generateJoin(CharBuffer cb) {
        cb.append(this._linkColumns.generateJoin(this._sourceFromItem.getName(), this._targetFromItem.getName()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManyToOneJoinExpr)) {
            return false;
        }
        ManyToOneJoinExpr joinExpr = (ManyToOneJoinExpr)o;
        return this._linkColumns.equals(joinExpr._linkColumns) && this._sourceFromItem.equals(joinExpr._sourceFromItem) && this._targetFromItem.equals(joinExpr._targetFromItem);
    }

    public String toString() {
        return new CharBuffer().append("ManyToOneJoinExpr[").append(this._linkColumns).append(",").append(this._sourceFromItem).append(",").append(this._targetFromItem).append("]").toString();
    }
}

