/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.query.CachedQueryKey;
import com.caucho.amber.query.ResultSetImpl;
import com.caucho.amber.query.SelectQuery;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedQuery {
    private SelectQuery _query;
    private CachedQueryKey _key;
    private ResultSetImpl _rs;
    private Type[] _argTypes;
    private Object[] _argValues;
    private int _argLength = 0;
    private long _loadTime;
    private ArrayList<Object> _values = new ArrayList();
    private volatile boolean _isLoading;
    private volatile boolean _isValidLoad;

    CachedQuery(UserQuery query) {
        this._query = (SelectQuery)query.getQuery();
        Type[] argTypes = query.getArgTypes();
        Object[] argValues = query.getArgValues();
        this._argLength = query.getArgLength();
        if (this._argLength > 0) {
            this._argTypes = new Type[this._argLength];
            this._argValues = new Object[this._argLength];
            for (int i = this._argLength - 1; i >= 0; --i) {
                this._argTypes[i] = argTypes[i];
                this._argValues[i] = argValues[i];
            }
        }
        this._key = new CachedQueryKey();
        this._key.init(this._query.getQueryString(), this._argValues, this._argLength);
        this._query.registerUpdates(this);
    }

    public CachedQueryKey getKey() {
        return this._key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        CachedQuery cachedQuery = this;
        synchronized (cachedQuery) {
            this._loadTime = 0L;
            this._isValidLoad = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(List<Object> list, AmberConnectionImpl aConn, long maxAge) throws SQLException {
        Type type = this._query.getResultType(0);
        EntityType entityType = (EntityType)type;
        JClass cl = entityType.getBeanClass();
        CachedQuery cachedQuery = this;
        synchronized (cachedQuery) {
            long now = Alarm.getCurrentTime();
            if (now < this._loadTime + maxAge || this._isLoading && this._loadTime > 0L) {
                int length = this._values.size();
                for (int i = 0; i < length; ++i) {
                    Object key = this._values.get(i);
                    list.add(aConn.loadLazy(cl.getName(), entityType.getName(), (Object)((Serializable)key)));
                }
                return;
            }
            this._isLoading = true;
            this._isValidLoad = true;
        }
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            ResultSetImpl rs = this.executeQuery(aConn);
            while (rs.next()) {
                values.add(rs.getKey(1));
                list.add(rs.getObject(1));
            }
            rs.close();
            CachedQuery cachedQuery2 = this;
            synchronized (cachedQuery2) {
                if (this._isValidLoad) {
                    this._values = values;
                    this._loadTime = Alarm.getCurrentTime();
                }
            }
        }
        finally {
            this._isLoading = false;
        }
    }

    private ResultSetImpl executeQuery(AmberConnectionImpl aConn) throws SQLException {
        if (this._rs == null) {
            this._rs = new ResultSetImpl();
        }
        PreparedStatement pstmt = aConn.prepareStatement(this._query.getSQL());
        pstmt.clearParameters();
        for (int i = 0; i < this._argLength; ++i) {
            if (this._argValues[i] == null) continue;
            this._argTypes[i].setParameter(pstmt, i + 1, this._argValues[i]);
        }
        ResultSet rs = pstmt.executeQuery();
        this._rs.setResultSet(rs);
        this._rs.setQuery(this._query);
        this._rs.setSession(aConn);
        this._rs.init();
        return this._rs;
    }

    public String toString() {
        return new CharBuffer().append("UserQuery[").append(this._query.getQueryString()).append("]").toString();
    }
}

